/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractCompletableAndSingleConcatenated;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import javax.annotation.Nullable;

final class SingleConcatWithCompletable<T>
extends AbstractCompletableAndSingleConcatenated<T> {
    private final Single<? extends T> original;
    private final Completable next;

    SingleConcatWithCompletable(Single<? extends T> original, Completable next, Executor executor) {
        super(executor);
        this.original = Objects.requireNonNull(original);
        this.next = Objects.requireNonNull(next);
    }

    @Override
    void delegateSubscribeToOriginal(SingleSource.Subscriber<? super T> offloadSubscriber, SignalOffloader offloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConcatWithSubscriber<T>(offloadSubscriber, this.next), offloader, contextMap, contextProvider);
    }

    private static final class ConcatWithSubscriber<T>
    extends AbstractCompletableAndSingleConcatenated.AbstractConcatWithSubscriber<T> {
        private final Completable next;
        @Nullable
        private T result;

        ConcatWithSubscriber(SingleSource.Subscriber<? super T> target, Completable next) {
            super(target);
            this.next = next;
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.result = result;
            this.subscribeToNext(this.next);
        }

        @Override
        public void onComplete() {
            this.sendSuccessToTarget(this.result);
        }
    }
}

