/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.OnSubscribeIgnoringSubscriberForOffloading;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.ScanWithMapper;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class ScanWithPublisher<T, R>
extends AbstractNoHandleSubscribePublisher<R> {
    private final Publisher<T> original;
    private final Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier;

    ScanWithPublisher(Publisher<T> original, final Supplier<R> initial, final BiFunction<R, ? super T, R> accumulator, Executor executor) {
        this(original, () -> new ScanWithMapper<T, R>(){
            @Nullable
            private Object state;
            {
                this.state = initial.get();
            }

            @Override
            public R mapOnNext(@Nullable T next) {
                this.state = accumulator.apply(this.state, next);
                return this.state;
            }

            @Override
            public R mapOnError(Throwable cause) {
                throw ScanWithPublisher.newMapTerminalUnsupported();
            }

            @Override
            public R mapOnComplete() {
                throw ScanWithPublisher.newMapTerminalUnsupported();
            }

            @Override
            public boolean mapTerminal() {
                return false;
            }
        }, executor);
    }

    ScanWithPublisher(Publisher<T> original, Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier, Executor executor) {
        super(executor, true);
        this.mapperSupplier = Objects.requireNonNull(mapperSupplier);
        this.original = original;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super R> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ScanWithSubscriber<T, R>(subscriber, this.mapperSupplier.get(), signalOffloader, contextMap, contextProvider), signalOffloader, contextMap, contextProvider);
    }

    private static IllegalStateException newMapTerminalUnsupported() {
        throw new IllegalStateException("mapTerminal returns false, this method should never be invoked!");
    }

    private static final class ScanWithSubscriber<T, R>
    implements PublisherSource.Subscriber<T> {
        private static final long TERMINATED = Long.MIN_VALUE;
        private static final long TERMINAL_PENDING = -9223372036854775807L;
        private static final long INVALID_DEMAND = -1L;
        private static final AtomicLongFieldUpdater<ScanWithSubscriber> demandUpdater = AtomicLongFieldUpdater.newUpdater(ScanWithSubscriber.class, "demand");
        private final PublisherSource.Subscriber<? super R> subscriber;
        private final SignalOffloader signalOffloader;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        private final ScanWithMapper<? super T, ? extends R> mapper;
        private volatile long demand;
        @Nullable
        private Throwable errorCause;

        ScanWithSubscriber(PublisherSource.Subscriber<? super R> subscriber, ScanWithMapper<? super T, ? extends R> mapper, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.signalOffloader = signalOffloader;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void onSubscribe(final PublisherSource.Subscription subscription) {
            this.subscriber.onSubscribe(new PublisherSource.Subscription(){

                @Override
                public void request(long n) {
                    if (!SubscriberUtils.isRequestNValid(n)) {
                        this.handleInvalidDemand(n);
                    } else if (demandUpdater.getAndAccumulate(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative) == -9223372036854775807L) {
                        demand = Long.MIN_VALUE;
                        if (errorCause != null) {
                            this.deliverOnError(errorCause, this.newOffloadedSubscriber());
                        } else {
                            this.deliverOnComplete(this.newOffloadedSubscriber());
                        }
                    } else {
                        subscription.request(n);
                    }
                }

                @Override
                public void cancel() {
                    demand = Long.MIN_VALUE;
                    subscription.cancel();
                }

                private void handleInvalidDemand(long n) {
                    if (demandUpdater.getAndSet(this, -1L) == -9223372036854775807L) {
                        demand = Long.MIN_VALUE;
                        this.newOffloadedSubscriber().onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                    } else {
                        subscription.request(n);
                    }
                }

                private PublisherSource.Subscriber<? super R> newOffloadedSubscriber() {
                    return OnSubscribeIgnoringSubscriberForOffloading.offloadWithDummyOnSubscribe(subscriber, signalOffloader, contextMap, contextProvider);
                }
            });
        }

        @Override
        public void onNext(@Nullable T t) {
            R mapped = this.mapper.mapOnNext(t);
            demandUpdater.decrementAndGet(this);
            this.subscriber.onNext(mapped);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onError(Throwable t) {
            boolean doMap;
            this.errorCause = t;
            try {
                doMap = this.mapper.mapTerminal();
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            if (doMap) {
                long currDemand;
                do {
                    if ((currDemand = this.demand) > 0L && demandUpdater.compareAndSet(this, currDemand, Long.MIN_VALUE)) {
                        this.deliverOnError(t, this.subscriber);
                        return;
                    }
                    if (currDemand == 0L && demandUpdater.compareAndSet(this, currDemand, -9223372036854775807L)) return;
                } while (currDemand >= 0L);
                this.subscriber.onError(t);
                return;
            }
            this.demand = Long.MIN_VALUE;
            this.subscriber.onError(t);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onComplete() {
            boolean doMap;
            try {
                doMap = this.mapper.mapTerminal();
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            if (doMap) {
                long currDemand;
                do {
                    if ((currDemand = this.demand) > 0L && demandUpdater.compareAndSet(this, currDemand, Long.MIN_VALUE)) {
                        this.deliverOnComplete(this.subscriber);
                        return;
                    }
                    if (currDemand == 0L && demandUpdater.compareAndSet(this, currDemand, -9223372036854775807L)) return;
                } while (currDemand >= 0L);
                this.subscriber.onError(new IllegalStateException("onComplete with invalid demand: " + currDemand));
                return;
            }
            this.demand = Long.MIN_VALUE;
            this.subscriber.onComplete();
        }

        private void deliverOnError(Throwable t, PublisherSource.Subscriber<? super R> subscriber) {
            try {
                subscriber.onNext(this.mapper.mapOnError(t));
            }
            catch (Throwable cause) {
                subscriber.onError(cause);
                return;
            }
            subscriber.onComplete();
        }

        private void deliverOnComplete(PublisherSource.Subscriber<? super R> subscriber) {
            try {
                subscriber.onNext(this.mapper.mapOnComplete());
            }
            catch (Throwable cause) {
                subscriber.onError(cause);
                return;
            }
            subscriber.onComplete();
        }
    }
}

