/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ResumeCompletable
extends AbstractNoHandleSubscribeCompletable {
    private final Completable original;
    private final Function<Throwable, ? extends Completable> nextFactory;

    ResumeCompletable(Completable original, Function<Throwable, ? extends Completable> nextFactory, Executor executor) {
        super(executor);
        this.original = original;
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ResumeSubscriber(subscriber, this.nextFactory, signalOffloader, contextMap, contextProvider), signalOffloader, contextMap, contextProvider);
    }

    private static final class ResumeSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber subscriber;
        private final SignalOffloader signalOffloader;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        @Nullable
        private Function<Throwable, ? extends Completable> nextFactory;

        ResumeSubscriber(CompletableSource.Subscriber subscriber, Function<Throwable, ? extends Completable> nextFactory, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.nextFactory = nextFactory;
            this.signalOffloader = signalOffloader;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.subscriber.onSubscribe(this.sequentialCancellable);
            } else {
                this.nextFactory = null;
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }

        @Override
        public void onError(Throwable throwable) {
            Completable next;
            if (this.nextFactory == null) {
                this.subscriber.onError(throwable);
                return;
            }
            try {
                next = Objects.requireNonNull(this.nextFactory.apply(throwable));
            }
            catch (Throwable t) {
                t.addSuppressed(throwable);
                this.subscriber.onError(t);
                return;
            }
            CompletableSource.Subscriber offloadedSubscriber = this.signalOffloader.offloadSubscriber(this.contextProvider.wrapCompletableSubscriber(this, this.contextMap));
            next.subscribeInternal(offloadedSubscriber);
        }
    }
}

