/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisher;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RangeIntPublisher
extends AbstractSynchronousPublisher<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeIntPublisher.class);
    private final int begin;
    private final int end;
    private final int stride;

    RangeIntPublisher(int begin, int end) {
        this(begin, end, 1);
    }

    RangeIntPublisher(int begin, int end, int stride) {
        if (begin > end) {
            throw new IllegalArgumentException("begin(" + begin + ") > end(" + end + ")");
        }
        if (stride <= 0) {
            throw new IllegalArgumentException("stride: " + stride + " (expected >0)");
        }
        this.begin = begin;
        this.end = end;
        this.stride = stride;
    }

    @Override
    void doSubscribe(PublisherSource.Subscriber<? super Integer> subscriber) {
        subscriber.onSubscribe(new RangeIntSubscription(subscriber));
    }

    private final class RangeIntSubscription
    implements PublisherSource.Subscription {
        private final PublisherSource.Subscriber<? super Integer> subscriber;
        private long pendingN;
        private int index;

        private RangeIntSubscription(PublisherSource.Subscriber<? super Integer> subscriber) {
            this.index = RangeIntPublisher.this.begin;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        @Override
        public void request(long n) {
            if (this.pendingN < 0L) {
                return;
            }
            if (!SubscriberUtils.isRequestNValid(n)) {
                this.sendOnError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                return;
            }
            if (this.pendingN != 0L) {
                this.pendingN = FlowControlUtils.addWithOverflowProtection(this.pendingN, n);
                return;
            }
            this.pendingN = FlowControlUtils.addWithOverflowProtection(this.pendingN, n);
            while (this.pendingN > 0L && this.index < RangeIntPublisher.this.end) {
                try {
                    this.subscriber.onNext((Integer)this.index);
                }
                catch (Throwable cause) {
                    this.sendOnError(cause);
                    return;
                }
                --this.pendingN;
                this.index = (int)((long)this.index + Math.min((long)RangeIntPublisher.this.stride, (long)RangeIntPublisher.this.end - (long)this.index));
            }
            if (this.index == RangeIntPublisher.this.end) {
                this.sendComplete();
            }
        }

        @Override
        public void cancel() {
            this.pendingN = -1L;
        }

        private void sendOnError(Throwable cause) {
            this.cancel();
            try {
                this.subscriber.onError(cause);
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onError of Subscriber {}.", (Object)this.subscriber, (Object)t);
            }
        }

        private void sendComplete() {
            this.cancel();
            try {
                this.subscriber.onComplete();
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", (Object)this.subscriber, (Object)t);
            }
        }
    }
}

