/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import java.util.Objects;

final class ContextPreservingSubscription
implements PublisherSource.Subscription {
    private final AsyncContextMap saved;
    private final PublisherSource.Subscription subscription;

    private ContextPreservingSubscription(PublisherSource.Subscription subscription, AsyncContextMap current) {
        this.subscription = Objects.requireNonNull(subscription);
        this.saved = Objects.requireNonNull(current);
    }

    static PublisherSource.Subscription wrap(PublisherSource.Subscription subscription, AsyncContextMap current) {
        return subscription instanceof ContextPreservingSubscription && ((ContextPreservingSubscription)subscription).saved == current ? subscription : new ContextPreservingSubscription(subscription, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long l) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.subscription.request(l);
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.requestSlowPath(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSlowPath(long l) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.subscription.request(l);
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.subscription.cancel();
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.cancelSlowPath();
        }
    }

    private void cancelSlowPath() {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.subscription.cancel();
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    public String toString() {
        return ContextPreservingSubscription.class.getSimpleName() + "(" + this.subscription + ')';
    }
}

