/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import java.util.Objects;

final class ContextPreservingRunnable
implements Runnable {
    private final AsyncContextMap saved;
    private final Runnable delegate;

    ContextPreservingRunnable(Runnable delegate) {
        this(delegate, DefaultAsyncContextProvider.INSTANCE.contextMap());
    }

    ContextPreservingRunnable(Runnable delegate, AsyncContextMap current) {
        this.saved = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.delegate.run();
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.slowPath();
        }
    }

    private void slowPath() {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.delegate.run();
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }
}

