/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import java.util.Objects;

class ContextPreservingCompletableSubscriber
implements CompletableSource.Subscriber {
    final AsyncContextMap saved;
    final CompletableSource.Subscriber subscriber;

    ContextPreservingCompletableSubscriber(CompletableSource.Subscriber subscriber, AsyncContextMap current) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.saved = Objects.requireNonNull(current);
    }

    void invokeOnSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(cancellable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSubscribe(Cancellable cancellable) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.invokeOnSubscribe(cancellable);
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.onSubscribeSlowPath(cancellable);
        }
    }

    private void onSubscribeSlowPath(Cancellable cancellable) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.invokeOnSubscribe(cancellable);
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onComplete() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.subscriber.onComplete();
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.onCompleteSlowPath();
        }
    }

    private void onCompleteSlowPath() {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.subscriber.onComplete();
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onError(Throwable t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.subscriber.onError(t);
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.onErrorSlowPath(t);
        }
    }

    private void onErrorSlowPath(Throwable t) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.subscriber.onError(t);
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subscriber + ')';
    }
}

