/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.CancelPropagatingCompletableFuture;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ContextPreservingCompletableFuture<T>
extends CompletableFuture<T> {
    private final CompletableFuture<T> delegate;
    private final AsyncContextMap saved;

    private ContextPreservingCompletableFuture(CompletableFuture<T> delegate, AsyncContextMap current) {
        this.delegate = Objects.requireNonNull(delegate);
        this.saved = Objects.requireNonNull(current);
    }

    static <T> ContextPreservingCompletableFuture<T> newContextPreservingFuture(CompletableFuture<T> original, AsyncContextMap contextMap) {
        ContextPreservingCompletableFuture<T> future = new ContextPreservingCompletableFuture<T>(original, contextMap);
        CancelPropagatingCompletableFuture.cascadeTermination(original, future);
        return future;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenApply(DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenApplyAsync(DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenApplyAsync(DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved), executor), this.saved);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAccept((Consumer)DefaultAsyncContextProvider.INSTANCE.wrapConsumer(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptAsync((Consumer)DefaultAsyncContextProvider.INSTANCE.wrapConsumer(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptAsync((Consumer)DefaultAsyncContextProvider.INSTANCE.wrapConsumer(action, this.saved), executor), this.saved);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenRun(DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenRunAsync(DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenRunAsync(DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved), executor), this.saved);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCombine(other, DefaultAsyncContextProvider.INSTANCE.wrapBiFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCombineAsync(other, DefaultAsyncContextProvider.INSTANCE.wrapBiFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCombineAsync(other, DefaultAsyncContextProvider.INSTANCE.wrapBiFunction(fn, this.saved), executor), this.saved);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptBoth(other, (BiConsumer)DefaultAsyncContextProvider.INSTANCE.wrapBiConsumer(action, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptBothAsync(other, (BiConsumer)DefaultAsyncContextProvider.INSTANCE.wrapBiConsumer(action, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptBothAsync(other, (BiConsumer)DefaultAsyncContextProvider.INSTANCE.wrapBiConsumer(action, this.saved), executor), this.saved);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterBoth((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterBothAsync((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterBothAsync((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved), executor), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.applyToEither((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.applyToEitherAsync((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.applyToEitherAsync((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved), executor), this.saved);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.acceptEither((CompletionStage)other, (Consumer)DefaultAsyncContextProvider.INSTANCE.wrapConsumer(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)DefaultAsyncContextProvider.INSTANCE.wrapConsumer(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)DefaultAsyncContextProvider.INSTANCE.wrapConsumer(action, this.saved), executor), this.saved);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterEither((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterEitherAsync((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterEitherAsync((CompletionStage)other, DefaultAsyncContextProvider.INSTANCE.wrapRunnable(action, this.saved), executor), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCompose(DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenComposeAsync(DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenComposeAsync(DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved), executor), this.saved);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.exceptionally(DefaultAsyncContextProvider.INSTANCE.wrapFunction(fn, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.whenComplete(DefaultAsyncContextProvider.INSTANCE.wrapBiConsumer(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.whenCompleteAsync(DefaultAsyncContextProvider.INSTANCE.wrapBiConsumer(action, this.saved)), this.saved);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.whenCompleteAsync(DefaultAsyncContextProvider.INSTANCE.wrapBiConsumer(action, this.saved), executor), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.handle(DefaultAsyncContextProvider.INSTANCE.wrapBiFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.handleAsync(DefaultAsyncContextProvider.INSTANCE.wrapBiFunction(fn, this.saved)), this.saved);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.handleAsync(DefaultAsyncContextProvider.INSTANCE.wrapBiFunction(fn, this.saved), executor), this.saved);
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.delegate.isCompletedExceptionally();
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    @Nullable
    public T join() {
        return this.delegate.join();
    }

    @Override
    @Nullable
    public T getNow(@Nullable T valueIfAbsent) {
        return this.delegate.getNow(valueIfAbsent);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        super.cancel(mayInterruptIfRunning);
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean complete(@Nullable T value) {
        super.complete(value);
        return this.delegate.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        super.completeExceptionally(ex);
        return this.delegate.completeExceptionally(ex);
    }

    @Override
    public void obtrudeValue(@Nullable T value) {
        super.obtrudeValue(value);
        this.delegate.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        super.obtrudeException(ex);
        this.delegate.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.delegate.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

