/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergedCancellableWithSubscription;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.DelayedSubscription;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class CompletableMergeWithPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Completable original;
    private final Publisher<? extends T> mergeWith;
    private final boolean delayError;

    CompletableMergeWithPublisher(Completable original, Publisher<? extends T> mergeWith, boolean delayError, Executor executor) {
        super(executor);
        this.mergeWith = mergeWith;
        this.original = original;
        this.delayError = delayError;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        if (this.delayError) {
            new MergerDelayError<T>(subscriber, signalOffloader, contextMap, contextProvider).merge(this.original, this.mergeWith, signalOffloader, contextMap, contextProvider);
        } else {
            new Merger<T>(subscriber, signalOffloader, contextMap, contextProvider).merge(this.original, this.mergeWith, signalOffloader, contextMap, contextProvider);
        }
    }

    private static final class Merger<T>
    implements PublisherSource.Subscriber<T> {
        private static final AtomicIntegerFieldUpdater<Merger> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(Merger.class, "state");
        private static final int PUBLISHER_TERMINATED = 1;
        private static final int COMPLETABLE_TERMINATED = 2;
        private static final int COMPLETABLE_ERROR = 4;
        private static final int IN_ON_NEXT = 8;
        private static final int ALL_TERMINATED = 3;
        private static final int COMPLETABLE_ALL_TERM = 7;
        private final CompletableSubscriber completableSubscriber;
        private final PublisherSource.Subscriber<? super T> offloadedSubscriber;
        private final DelayedSubscription subscription = new DelayedSubscription();
        @Nullable
        private Throwable completableError;
        private volatile int state;

        Merger(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.offloadedSubscriber = signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriber(subscriber, contextMap));
            this.completableSubscriber = new CompletableSubscriber();
        }

        void merge(Completable original, Publisher<? extends T> mergeWith, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.offloadedSubscriber.onSubscribe(new MergedCancellableWithSubscription(this.subscription, this.completableSubscriber));
            original.delegateSubscribe(this.completableSubscriber, signalOffloader, contextMap, contextProvider);
            mergeWith.subscribeInternal(this);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription targetSubscription) {
            this.subscription.delayedSubscription(ConcurrentSubscription.wrap(targetSubscription));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(@Nullable T t) {
            int currState;
            while (!Merger.isState(currState = this.state, 3)) {
                if (Merger.isState(currState, 2)) {
                    this.offloadedSubscriber.onNext(t);
                    break;
                }
                int newState = Merger.setState(currState, 8);
                if (!stateUpdater.compareAndSet(this, currState, newState)) continue;
                try {
                    this.offloadedSubscriber.onNext(t);
                    break;
                }
                finally {
                    if (!Merger.isState(currState, 8) && !stateUpdater.compareAndSet(this, newState, Merger.clearState(newState, 8))) {
                        this.onNextUnLockFail();
                    }
                }
            }
        }

        private void onNextUnLockFail() {
            int currState;
            do {
                if (!Merger.isState(currState = this.state, 4)) continue;
                assert (this.completableError != null);
                this.offloadedSubscriber.onError(this.completableError);
                break;
            } while (!stateUpdater.compareAndSet(this, currState, Merger.clearState(currState, 8)));
        }

        @Override
        public void onError(Throwable t) {
            int currState;
            while (!Merger.isState(currState = this.state, 1)) {
                if (!stateUpdater.compareAndSet(this, currState, Merger.setState(currState, 3))) continue;
                try {
                    if (Merger.isState(currState, 2)) break;
                    this.completableSubscriber.cancel();
                    break;
                }
                finally {
                    this.offloadedSubscriber.onError(t);
                }
            }
        }

        @Override
        public void onComplete() {
            int currState;
            while (!Merger.isState(currState = this.state, 1)) {
                if (!stateUpdater.compareAndSet(this, currState, Merger.setState(currState, 1))) continue;
                if (!Merger.isState(currState, 2)) break;
                this.offloadedSubscriber.onComplete();
                break;
            }
        }

        private static boolean isState(int state, int stateToCheck) {
            return (state & stateToCheck) == stateToCheck;
        }

        private static int clearState(int state, int stateToClear) {
            return state & ~stateToClear;
        }

        private static int setState(int state, int stateToSet) {
            return state | stateToSet;
        }

        private final class CompletableSubscriber
        extends DelayedCancellable
        implements CompletableSource.Subscriber {
            private CompletableSubscriber() {
            }

            @Override
            public void onSubscribe(Cancellable cancellable) {
                this.delayedCancellable(cancellable);
            }

            @Override
            public void onComplete() {
                int currState;
                while (!Merger.isState(currState = Merger.this.state, 2)) {
                    if (!stateUpdater.compareAndSet(Merger.this, currState, Merger.setState(currState, 2))) continue;
                    if (!Merger.isState(currState, 1)) break;
                    Merger.this.offloadedSubscriber.onComplete();
                    break;
                }
            }

            @Override
            public void onError(Throwable t) {
                int currState;
                Merger.this.completableError = t;
                while (!Merger.isState(currState = Merger.this.state, 2)) {
                    if (!stateUpdater.compareAndSet(Merger.this, currState, Merger.setState(currState, 7))) continue;
                    try {
                        if (Merger.isState(currState, 1)) break;
                        Merger.this.subscription.cancel();
                        break;
                    }
                    finally {
                        if (!Merger.isState(currState, 8)) {
                            Merger.this.offloadedSubscriber.onError(t);
                        }
                    }
                }
            }
        }
    }

    private static final class MergerDelayError<T>
    implements PublisherSource.Subscriber<T> {
        private static final AtomicReferenceFieldUpdater<MergerDelayError, TerminalSignal> terminalUpdater = AtomicReferenceFieldUpdater.newUpdater(MergerDelayError.class, TerminalSignal.class, "terminal");
        private final CompletableSubscriber completableSubscriber;
        private final PublisherSource.Subscriber<? super T> offloadedSubscriber;
        private final DelayedSubscription subscription = new DelayedSubscription();
        @Nullable
        private volatile TerminalSignal terminal;

        MergerDelayError(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.offloadedSubscriber = signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriber(subscriber, contextMap));
            this.completableSubscriber = new CompletableSubscriber();
        }

        void merge(Completable original, Publisher<? extends T> mergeWith, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.offloadedSubscriber.onSubscribe(new MergedCancellableWithSubscription(this.subscription, this.completableSubscriber));
            original.delegateSubscribe(this.completableSubscriber, signalOffloader, contextMap, contextProvider);
            mergeWith.subscribeInternal(this);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.subscription.delayedSubscription(subscription);
        }

        @Override
        public void onNext(@Nullable T t) {
            this.offloadedSubscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.terminateSubscriber(new TerminalSignal(t, true));
        }

        @Override
        public void onComplete() {
            this.terminateSubscriber(TerminalSignal.PUB_COMPLETED);
        }

        private void terminateSubscriber(TerminalSignal terminalSignal) {
            do {
                TerminalSignal currState;
                if ((currState = this.terminal) == null) continue;
                if (currState.fromPublisher == terminalSignal.fromPublisher) {
                    throw MergerDelayError.duplicateTerminalException(currState);
                }
                if (currState.cause == null) {
                    if (terminalSignal.cause == null) {
                        this.offloadedSubscriber.onComplete();
                    } else {
                        this.offloadedSubscriber.onError(terminalSignal.cause);
                    }
                } else {
                    this.offloadedSubscriber.onError(currState.cause);
                }
                break;
            } while (!terminalUpdater.compareAndSet(this, null, terminalSignal));
        }

        private static IllegalStateException duplicateTerminalException(TerminalSignal currState) {
            throw new IllegalStateException("duplicate terminal event from " + (currState.fromPublisher ? Publisher.class.getSimpleName() : Completable.class.getSimpleName()), currState.cause);
        }

        private static final class TerminalSignal {
            private static final TerminalSignal PUB_COMPLETED = new TerminalSignal(true);
            private static final TerminalSignal COM_COMPLETED = new TerminalSignal(false);
            @Nullable
            final Throwable cause;
            final boolean fromPublisher;

            TerminalSignal(boolean fromPublisher) {
                this.cause = null;
                this.fromPublisher = fromPublisher;
            }

            TerminalSignal(Throwable cause, boolean fromPublisher) {
                this.cause = Objects.requireNonNull(cause);
                this.fromPublisher = fromPublisher;
            }
        }

        private final class CompletableSubscriber
        extends DelayedCancellable
        implements CompletableSource.Subscriber {
            private CompletableSubscriber() {
            }

            @Override
            public void onSubscribe(Cancellable cancellable) {
                this.delayedCancellable(cancellable);
            }

            @Override
            public void onComplete() {
                MergerDelayError.this.terminateSubscriber(TerminalSignal.COM_COMPLETED);
            }

            @Override
            public void onError(Throwable t) {
                MergerDelayError.this.terminateSubscriber(new TerminalSignal(t, false));
            }
        }
    }
}

