/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class CancellableSet
implements Cancellable {
    private static final AtomicReferenceFieldUpdater<CancellableSet, Set> setUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellableSet.class, Set.class, "set");
    @Nullable
    private volatile Set<Cancellable> set;

    CancellableSet() {
        this(8);
    }

    CancellableSet(int initialSize) {
        this.set = Collections.newSetFromMap(new ConcurrentHashMap(initialSize));
    }

    @Override
    public void cancel() {
        Set currentSet = setUpdater.getAndSet(this, null);
        if (currentSet != null) {
            Throwable delayedCause = null;
            for (Cancellable c : currentSet) {
                try {
                    if (!currentSet.remove(c)) continue;
                    c.cancel();
                }
                catch (Throwable cause) {
                    delayedCause = ThrowableUtils.catchUnexpected(delayedCause, cause);
                }
            }
            if (delayedCause != null) {
                PlatformDependent.throwException(delayedCause);
            }
        }
    }

    boolean add(Cancellable toAdd) {
        Set<Cancellable> currentSet = this.set;
        if (currentSet == null) {
            toAdd.cancel();
            return false;
        }
        if (!currentSet.add(toAdd)) {
            return false;
        }
        if (!setUpdater.compareAndSet(this, currentSet, currentSet)) {
            if (currentSet.remove(toAdd)) {
                toAdd.cancel();
            }
            return false;
        }
        return true;
    }

    boolean remove(Cancellable toRemove) {
        Set<Cancellable> currentSet = this.set;
        return currentSet != null && currentSet.remove(toRemove);
    }

    boolean isCancelled() {
        return this.set == null;
    }
}

