/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletableProcessor;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.SignalOffloaderFactory;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

abstract class AbstractOffloaderAwareExecutor
implements SignalOffloaderFactory,
Executor {
    private static final AtomicReferenceFieldUpdater<AbstractOffloaderAwareExecutor, CompletableProcessor> onCloseUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractOffloaderAwareExecutor.class, CompletableProcessor.class, "onClose");
    @Nullable
    private volatile CompletableProcessor onClose;

    AbstractOffloaderAwareExecutor() {
    }

    @Override
    public Completable onClose() {
        return this.getOrCreateOnClose();
    }

    @Override
    public Completable closeAsync() {
        return new CloseAsync();
    }

    private CompletableProcessor getOrCreateOnClose() {
        CompletableProcessor onClose = this.onClose;
        if (onClose != null) {
            return onClose;
        }
        CompletableProcessor newOnClose = new CompletableProcessor();
        if (onCloseUpdater.compareAndSet(this, null, newOnClose)) {
            return newOnClose;
        }
        onClose = this.onClose;
        assert (onClose != null);
        return onClose;
    }

    abstract void doClose();

    private final class CloseAsync
    extends Completable
    implements CompletableSource {
        private CloseAsync() {
        }

        @Override
        protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
            CompletableProcessor onClose = AbstractOffloaderAwareExecutor.this.getOrCreateOnClose();
            onClose.subscribeInternal(subscriber);
            try {
                AbstractOffloaderAwareExecutor.this.doClose();
            }
            catch (Throwable cause) {
                onClose.onError(cause);
                return;
            }
            onClose.onComplete();
        }

        @Override
        public void subscribe(CompletableSource.Subscriber subscriber) {
            this.subscribeInternal(subscriber);
        }
    }
}

