/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import io.servicetalk.client.api.ServiceDiscovererEvent;
import java.util.Objects;

public final class DefaultServiceDiscovererEvent<T>
implements ServiceDiscovererEvent<T> {
    private final T address;
    private final boolean available;

    public DefaultServiceDiscovererEvent(T address, boolean available) {
        this.address = Objects.requireNonNull(address);
        this.available = available;
    }

    @Override
    public T address() {
        return this.address;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceDiscovererEvent that = (DefaultServiceDiscovererEvent)o;
        if (this.available != that.available) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + (this.available ? 1 : 0);
        return result;
    }

    public String toString() {
        return "DefaultServiceDiscovererEvent{address=" + this.address + ", available=" + this.available + '}';
    }
}

