/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.projection;

import io.serialized.client.projection.Function;
import io.serialized.client.projection.ProjectionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ProjectionDefinition {
    private String projectionName;
    private String feedName;
    private boolean aggregated;
    private String idField;
    private String signingSecret;
    private List<ProjectionHandler> handlers;
    private List<String> indexedFields;

    public static SingleProjectionBuilder singleProjection(String projectionName) {
        return new SingleProjectionBuilder(projectionName);
    }

    public static AggregatedProjectionBuilder aggregatedProjection(String projectionName) {
        return new AggregatedProjectionBuilder(projectionName);
    }

    public String feedName() {
        return this.feedName;
    }

    public boolean aggregated() {
        return this.aggregated;
    }

    public String idField() {
        return this.idField;
    }

    public String signingSecret() {
        return this.signingSecret;
    }

    public List<ProjectionHandler> handlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public List<String> indexedFields() {
        return this.indexedFields != null ? Collections.unmodifiableList(this.indexedFields) : null;
    }

    public String projectionName() {
        return this.projectionName;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class SingleProjectionBuilder {
        private final List<ProjectionHandler> handlers = new ArrayList<ProjectionHandler>();
        private final String projectionName;
        private String feedName;
        private String idField;
        private String signingSecret;
        private List<String> indexedFields;

        SingleProjectionBuilder(String projectionName) {
            this.projectionName = projectionName;
        }

        public SingleProjectionBuilder feed(String feedName) {
            this.feedName = feedName;
            return this;
        }

        public SingleProjectionBuilder signingSecret(String signingSecret) {
            this.signingSecret = signingSecret;
            return this;
        }

        public SingleProjectionBuilder addHandler(ProjectionHandler handler) {
            this.handlers.add(handler);
            return this;
        }

        public SingleProjectionBuilder addHandler(String eventType, Function ... functions) {
            ProjectionHandler.Builder builder = ProjectionHandler.handler(eventType);
            Arrays.asList(functions).forEach(builder::addFunction);
            return this.addHandler(builder.build());
        }

        public SingleProjectionBuilder withIdField(String idField) {
            this.idField = idField;
            return this;
        }

        public SingleProjectionBuilder withIndexedFields(List<String> indexedFields) {
            this.indexedFields = indexedFields;
            return this;
        }

        public ProjectionDefinition build() {
            Validate.isTrue((!this.handlers.isEmpty() ? 1 : 0) != 0, (String)"'handlers' must not be empty", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.projectionName, (String)"'projectionName' must be set", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.feedName, (String)"'feedName' must be set", (Object[])new Object[0]);
            ProjectionDefinition definition = new ProjectionDefinition();
            definition.projectionName = this.projectionName;
            definition.feedName = this.feedName;
            definition.aggregated = false;
            definition.idField = this.idField;
            definition.handlers = this.handlers;
            definition.signingSecret = this.signingSecret;
            definition.indexedFields = this.indexedFields;
            return definition;
        }
    }

    public static class AggregatedProjectionBuilder {
        private final List<ProjectionHandler> handlers = new ArrayList<ProjectionHandler>();
        private final String projectionName;
        private String feedName;
        private String signingSecret;
        private List<String> indexedFields;

        AggregatedProjectionBuilder(String projectionName) {
            this.projectionName = projectionName;
        }

        public AggregatedProjectionBuilder feed(String feedName) {
            this.feedName = feedName;
            return this;
        }

        public AggregatedProjectionBuilder signingSecret(String signingSecret) {
            this.signingSecret = signingSecret;
            return this;
        }

        public AggregatedProjectionBuilder addHandler(ProjectionHandler handler) {
            this.handlers.add(handler);
            return this;
        }

        public AggregatedProjectionBuilder addHandler(String eventType, Function ... functions) {
            ProjectionHandler.Builder builder = ProjectionHandler.handler(eventType);
            Arrays.asList(functions).forEach(builder::addFunction);
            return this.addHandler(builder.build());
        }

        public AggregatedProjectionBuilder withIndexedFields(List<String> indexedFields) {
            this.indexedFields = indexedFields;
            return this;
        }

        public ProjectionDefinition build() {
            Validate.isTrue((!this.handlers.isEmpty() ? 1 : 0) != 0, (String)"'handlers' must not be empty", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.projectionName, (String)"'projectionName' must be set", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.feedName, (String)"'feedName' must be set", (Object[])new Object[0]);
            ProjectionDefinition definition = new ProjectionDefinition();
            definition.projectionName = this.projectionName;
            definition.feedName = this.feedName;
            definition.aggregated = true;
            definition.handlers = this.handlers;
            definition.signingSecret = this.signingSecret;
            definition.indexedFields = this.indexedFields;
            return definition;
        }
    }
}

