/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.aggregate;

public interface RetryStrategy {
    public static final RetryStrategy DEFAULT = new Builder().withRetryCount(0).withSleepMs(0).build();

    public int getRetryCount();

    public int getSleepMs();

    public static class Builder {
        private int retryCount;
        private int sleepMs;

        public Builder withRetryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder withSleepMs(int sleepMs) {
            this.sleepMs = sleepMs;
            return this;
        }

        public RetryStrategy build() {
            return new RetryStrategy(){

                @Override
                public int getRetryCount() {
                    return retryCount;
                }

                @Override
                public int getSleepMs() {
                    return sleepMs;
                }
            };
        }
    }
}

