/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.tenant;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.serialized.client.SerializedClientConfig;
import io.serialized.client.SerializedOkHttpClient;
import io.serialized.client.tenant.Tenant;
import io.serialized.client.tenant.TenantsResponse;
import java.util.List;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class TenantClient {
    private final SerializedOkHttpClient client;
    private final HttpUrl apiRoot;

    private TenantClient(Builder builder) {
        this.client = new SerializedOkHttpClient(builder.httpClient, builder.objectMapper);
        this.apiRoot = builder.apiRoot;
    }

    public static Builder tenantClient(SerializedClientConfig config) {
        return new Builder(config);
    }

    public void addTenant(Tenant tenant) {
        HttpUrl url = this.apiRoot.newBuilder().addPathSegment("tenants").build();
        this.client.post(url, tenant);
    }

    public List<Tenant> listTenants() {
        HttpUrl url = this.apiRoot.newBuilder().addPathSegment("tenants").build();
        return this.client.get(url, TenantsResponse.class).tenants();
    }

    public void deleteTenant(UUID tenantId) {
        HttpUrl url = this.apiRoot.newBuilder().addPathSegment("tenants").addPathSegment(tenantId.toString()).build();
        this.client.delete(url);
    }

    public static class Builder {
        private final OkHttpClient httpClient;
        private final ObjectMapper objectMapper;
        private final HttpUrl apiRoot;

        public Builder(SerializedClientConfig config) {
            this.httpClient = config.httpClient();
            this.objectMapper = config.objectMapper();
            this.apiRoot = config.apiRoot();
        }

        public TenantClient build() {
            return new TenantClient(this);
        }
    }
}

