/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.reaction;

import io.serialized.client.reaction.ReactionDefinition;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;

public class Actions {
    public static HttpActionBuilder httpAction(URI targetUri) {
        return new HttpActionBuilder(targetUri);
    }

    public static SlackActionBuilder slackAction(URI targetUri) {
        return new SlackActionBuilder(targetUri);
    }

    public static IftttActionBuilder iftttAction(URI targetUri) {
        return new IftttActionBuilder(targetUri);
    }

    public static AutomateActionBuilder automateAction(URI targetUri) {
        return new AutomateActionBuilder(targetUri);
    }

    public static ZapierActionBuilder zapierAction(URI targetUri) {
        return new ZapierActionBuilder(targetUri);
    }

    public static class ZapierActionBuilder {
        private final Set<String> allowedKeys = Stream.of("value1", "value2", "value3", "value4", "value5", "value6", "value7", "value8", "value9").collect(Collectors.toSet());
        private final Map<String, String> valueMap = new LinkedHashMap<String, String>();
        private final URI webHookUrl;

        ZapierActionBuilder(URI webHookUrl) {
            this.webHookUrl = webHookUrl;
        }

        public ZapierActionBuilder add(String key, String value) {
            Validate.isTrue((boolean)this.allowedKeys.contains(key), (String)("Illegal key name: " + key), (Object[])new Object[0]);
            this.valueMap.put(key, value);
            return this;
        }

        public ReactionDefinition.Action build() {
            return ReactionDefinition.Action.newAction("ZAPIER_POST", this.webHookUrl, Collections.emptyMap(), null, this.valueMap);
        }
    }

    public static class AutomateActionBuilder {
        private final Set<String> allowedKeys = Stream.of("value1", "value2", "value3", "value4", "value5", "value6", "value7", "value8", "value9").collect(Collectors.toSet());
        private final Map<String, String> valueMap = new LinkedHashMap<String, String>();
        private final URI webHookUrl;

        AutomateActionBuilder(URI webHookUrl) {
            this.webHookUrl = webHookUrl;
        }

        public AutomateActionBuilder add(String key, String value) {
            Validate.isTrue((boolean)this.allowedKeys.contains(key), (String)("Illegal key name: " + key), (Object[])new Object[0]);
            this.valueMap.put(key, value);
            return this;
        }

        public ReactionDefinition.Action build() {
            return ReactionDefinition.Action.newAction("AUTOMATE_POST", this.webHookUrl, Collections.emptyMap(), null, this.valueMap);
        }
    }

    public static class IftttActionBuilder {
        private final Set<String> allowedKeys = Stream.of("value1", "value2", "value3").collect(Collectors.toSet());
        private final Map<String, String> valueMap = new LinkedHashMap<String, String>();
        private final URI webHookUrl;

        IftttActionBuilder(URI webHookUrl) {
            this.webHookUrl = webHookUrl;
        }

        public IftttActionBuilder add(String key, String value) {
            Validate.isTrue((boolean)this.allowedKeys.contains(key), (String)("Illegal key name: " + key), (Object[])new Object[0]);
            this.valueMap.put(key, value);
            return this;
        }

        public ReactionDefinition.Action build() {
            return ReactionDefinition.Action.newAction("IFTTT_POST", this.webHookUrl, Collections.emptyMap(), null, this.valueMap);
        }
    }

    public static class SlackActionBuilder {
        private final URI webHookUrl;
        private String text;

        SlackActionBuilder(URI webHookUrl) {
            this.webHookUrl = webHookUrl;
        }

        public SlackActionBuilder text(String text) {
            this.text = text;
            return this;
        }

        public ReactionDefinition.Action build() {
            return ReactionDefinition.Action.newAction("SLACK_POST", this.webHookUrl, Collections.emptyMap(), this.text, null);
        }
    }

    public static class HttpActionBuilder {
        private final URI targetUri;
        private final Map<String, Object> httpHeaders = new LinkedHashMap<String, Object>();

        HttpActionBuilder(URI targetUri) {
            this.targetUri = targetUri;
        }

        public HttpActionBuilder addHeader(String key, String value) {
            this.httpHeaders.put(key, value);
            return this;
        }

        public HttpActionBuilder addHeaders(Map<String, String> headers) {
            this.httpHeaders.putAll(headers);
            return this;
        }

        public ReactionDefinition.Action build() {
            return ReactionDefinition.Action.newAction("HTTP_POST", this.targetUri, this.httpHeaders, null, null);
        }
    }
}

