/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.projection;

import io.serialized.client.projection.Function;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ProjectionHandler {
    private String eventType;
    private List<Function> functions = new ArrayList<Function>();
    private URI functionUri;
    private String idField;

    public static Builder handler(String eventType) {
        return new Builder(eventType);
    }

    public static ProjectionHandler handler(String eventType, Function ... functions) {
        Builder builder = new Builder(eventType);
        for (Function function : functions) {
            builder.addFunction(function);
        }
        return builder.build();
    }

    public static Builder newHandler(String eventType, Function ... functions) {
        Builder builder = new Builder(eventType);
        for (Function function : functions) {
            builder.addFunction(function);
        }
        return builder;
    }

    public String eventType() {
        return this.eventType;
    }

    public List<Function> functions() {
        return Collections.unmodifiableList(this.functions);
    }

    public URI functionUri() {
        return this.functionUri;
    }

    public String idField() {
        return this.idField;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class Builder {
        private final String eventType;
        private final List<Function> functions = new ArrayList<Function>();
        private URI functionUri;
        private String idField;

        public Builder(String eventType) {
            this.eventType = eventType;
        }

        public Builder addFunction(Function function) {
            Validate.isTrue((this.functionUri == null ? 1 : 0) != 0, (String)"Cannot combine 'functions' and 'functionUri'", (Object[])new Object[0]);
            this.functions.add(function);
            return this;
        }

        public Builder withFunctionUri(URI functionUri) {
            Validate.isTrue((boolean)this.functions.isEmpty(), (String)"Cannot combine 'functions' and 'functionUri'", (Object[])new Object[0]);
            this.functionUri = functionUri;
            return this;
        }

        public Builder withIdField(String idField) {
            this.idField = idField;
            return this;
        }

        public ProjectionHandler build() {
            Validate.notEmpty((CharSequence)this.eventType, (String)"'eventType' must be set", (Object[])new Object[0]);
            ProjectionHandler projectionHandler = new ProjectionHandler();
            projectionHandler.eventType = this.eventType;
            projectionHandler.functions = this.functions;
            projectionHandler.functionUri = this.functionUri;
            projectionHandler.idField = this.idField;
            return projectionHandler;
        }
    }
}

