/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.serialized.client.ApiException;
import io.serialized.client.ClientException;
import io.serialized.client.SerializedClientConfig;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Function;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SerializedOkHttpClient {
    public static final String SERIALIZED_TENANT_ID = "Serialized-Tenant-Id";
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public SerializedOkHttpClient(OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public void put(HttpUrl url, Object payload) {
        this.execute(this.putRequest(url, payload).build(), res -> null);
    }

    public void put(HttpUrl url, Object payload, UUID tenantId) {
        this.execute(this.putRequest(url, payload).header(SERIALIZED_TENANT_ID, tenantId.toString()).build(), res -> null);
    }

    public void post(HttpUrl url, Object payload) {
        this.execute(this.postRequest(url, payload).build(), res -> null);
    }

    public void post(HttpUrl url, Object payload, UUID tenantId) {
        this.execute(this.postRequest(url, payload).header(SERIALIZED_TENANT_ID, tenantId.toString()).build(), res -> null);
    }

    public void delete(HttpUrl url) {
        this.execute(this.deleteRequest(url).build(), res -> null);
    }

    public <T> T delete(HttpUrl url, Class<T> responseClass) {
        return (T)this.executeAndGet(this.deleteRequest(url), contents -> this.parseJsonAs((String)contents, responseClass));
    }

    public <T> T delete(HttpUrl url, UUID tenantId) {
        return (T)this.executeAndGet(this.deleteRequest(url).header(SERIALIZED_TENANT_ID, tenantId.toString()), res -> null);
    }

    public <T> T delete(HttpUrl url, Class<T> responseClass, UUID tenantId) {
        return (T)this.executeAndGet(this.deleteRequest(url).header(SERIALIZED_TENANT_ID, tenantId.toString()), contents -> this.parseJsonAs((String)contents, responseClass));
    }

    public <T> T head(HttpUrl url, Function<Response, T> handler) {
        return this.execute(this.headRequest(url).build(), handler);
    }

    public <T> T head(HttpUrl url, Function<Response, T> handler, UUID tenantId) {
        return this.execute(this.headRequest(url).header(SERIALIZED_TENANT_ID, tenantId.toString()).build(), handler);
    }

    public <T> T get(HttpUrl url, Class<T> responseClass) {
        return (T)this.executeAndGet(this.getRequest(url), contents -> this.parseJsonAs((String)contents, responseClass));
    }

    public <T> T get(HttpUrl url, Class<T> responseClass, UUID tenantId) {
        return (T)this.executeAndGet(this.getRequest(url).header(SERIALIZED_TENANT_ID, tenantId.toString()), contents -> this.parseJsonAs((String)contents, responseClass));
    }

    public <T> T get(HttpUrl url, JavaType type) {
        return (T)this.executeAndGet(this.getRequest(url), contents -> this.parseJsonAs((String)contents, type));
    }

    public <T> T get(HttpUrl url, JavaType type, UUID tenantId) {
        return (T)this.executeAndGet(this.getRequest(url).header(SERIALIZED_TENANT_ID, tenantId.toString()), contents -> this.parseJsonAs((String)contents, type));
    }

    private Request.Builder putRequest(HttpUrl url, Object payload) {
        return new Request.Builder().url(url).put(RequestBody.create((MediaType)SerializedClientConfig.JSON_MEDIA_TYPE, (String)this.toJson(payload)));
    }

    private Request.Builder postRequest(HttpUrl url, Object payload) {
        return new Request.Builder().url(url).post(RequestBody.create((MediaType)SerializedClientConfig.JSON_MEDIA_TYPE, (String)this.toJson(payload)));
    }

    private Request.Builder deleteRequest(HttpUrl url) {
        return new Request.Builder().url(url).delete();
    }

    private Request.Builder headRequest(HttpUrl url) {
        return new Request.Builder().url(url).head();
    }

    private Request.Builder getRequest(HttpUrl url) {
        return new Request.Builder().url(url).get();
    }

    private <T> T executeAndGet(Request.Builder request, Function<String, T> contentParser) {
        return (T)this.execute(request.build(), response -> {
            try {
                String responseContents = response.body().string();
                return contentParser.apply(responseContents);
            }
            catch (IOException e) {
                throw new ClientException(e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Request request, Function<Response, T> handler) {
        try (Response res = this.httpClient.newCall(request).execute();){
            if (!res.isSuccessful()) {
                throw new ApiException(res.code(), this.nullSafeBody(res));
            }
            Response response = handler.apply(res);
            return (T)response;
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    private String nullSafeBody(Response res) throws IOException {
        return res.body() != null ? res.body().string() : res.message();
    }

    private <T> T parseJsonAs(String contents, Class<T> responseClass) {
        try {
            return (T)this.objectMapper.readValue(contents, responseClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T parseJsonAs(String contents, JavaType type) {
        try {
            return (T)this.objectMapper.readValue(contents, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String toJson(Object payload) {
        try {
            return this.objectMapper.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new ClientException(e);
        }
    }
}

