/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.net.URI;
import java.util.function.Supplier;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.Validate;

public class SerializedClientConfig {
    public static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String HTTPS_API_SERIALIZED_IO = "https://api.serialized.io/";
    private final OkHttpClient httpClient;
    private final Supplier<ObjectMapper> objectMapper;
    private final HttpUrl apiRoot;

    private SerializedClientConfig(OkHttpClient httpClient, Supplier<ObjectMapper> objectMapper, HttpUrl apiRoot) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.apiRoot = apiRoot;
    }

    public static Builder serializedConfig() {
        return new Builder();
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper.get();
    }

    public HttpUrl apiRoot() {
        return this.apiRoot;
    }

    public static class Builder {
        private URI rootApiUrl = URI.create("https://api.serialized.io/");
        private String accessKey;
        private String secretAccessKey;
        private final Supplier<ObjectMapper> objectMapper = () -> new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setSerializationInclusion(JsonInclude.Include.NON_NULL);

        public Builder rootApiUrl(String rootApiUrl) {
            this.rootApiUrl = URI.create(rootApiUrl);
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public SerializedClientConfig build() {
            Validate.notNull((Object)this.rootApiUrl, (String)"'rootApiUrl' must be set", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.accessKey, (String)"'accessKey' must be set", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.secretAccessKey, (String)"'secretAccessKey' must be set", (Object[])new Object[0]);
            HttpUrl apiRoot = HttpUrl.get((URI)this.rootApiUrl);
            OkHttpClient client = new OkHttpClient.Builder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("Serialized-Access-Key", this.accessKey).addHeader("Serialized-Secret-Access-Key", this.secretAccessKey).build())).build();
            return new SerializedClientConfig(client, this.objectMapper, apiRoot);
        }
    }
}

