/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.reaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.serialized.client.SerializedClientConfig;
import io.serialized.client.SerializedOkHttpClient;
import io.serialized.client.reaction.ReactionDefinition;
import io.serialized.client.reaction.ReactionDefinitions;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ReactionClient {
    private final SerializedOkHttpClient client;
    private final HttpUrl apiRoot;
    private final ObjectMapper objectMapper;

    private ReactionClient(Builder builder) {
        this.client = new SerializedOkHttpClient(builder.httpClient, builder.objectMapper);
        this.apiRoot = builder.apiRoot;
        this.objectMapper = builder.objectMapper;
    }

    public static Builder reactionClient(SerializedClientConfig config) {
        return new Builder(config);
    }

    public void createDefinition(ReactionDefinition reactionDefinition) {
        HttpUrl url = this.pathForDefinition().build();
        this.client.post(url, reactionDefinition);
    }

    public void createDefinition(String jsonString) throws IOException {
        ReactionDefinition reactionDefinition = (ReactionDefinition)this.objectMapper.readValue(jsonString, ReactionDefinition.class);
        this.createDefinition(reactionDefinition);
    }

    public void createOrUpdate(ReactionDefinition reactionDefinition) {
        String reactionName = reactionDefinition.getReactionName();
        HttpUrl url = this.pathForDefinition().addPathSegment(reactionName).build();
        this.client.put(url, reactionDefinition);
    }

    public void createOrUpdate(String jsonString) throws IOException {
        ReactionDefinition reactionDefinition = (ReactionDefinition)this.objectMapper.readValue(jsonString, ReactionDefinition.class);
        this.createOrUpdate(reactionDefinition);
    }

    public ReactionDefinition getDefinition(String reactionName) {
        HttpUrl url = this.pathForDefinition().addPathSegment(reactionName).build();
        return this.client.get(url, ReactionDefinition.class);
    }

    public ReactionDefinitions listDefinitions() {
        HttpUrl url = this.pathForDefinition().build();
        return this.client.get(url, ReactionDefinitions.class);
    }

    public void deleteDefinition(String reactionName) {
        HttpUrl url = this.pathForDefinition().addPathSegment(reactionName).build();
        this.client.delete(url);
    }

    private HttpUrl.Builder pathForDefinition() {
        return this.apiRoot.newBuilder().addPathSegment("reactions").addPathSegment("definitions");
    }

    public static class Builder {
        private final OkHttpClient httpClient;
        private final ObjectMapper objectMapper;
        private final HttpUrl apiRoot;

        Builder(SerializedClientConfig config) {
            this.httpClient = config.httpClient();
            this.objectMapper = config.objectMapper();
            this.apiRoot = config.apiRoot();
        }

        public ReactionClient build() {
            return new ReactionClient(this);
        }
    }
}

