/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.reaction;

import io.serialized.client.reaction.ReactionDefinition;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Actions {
    public static HttpActionBuilder httpAction(URI targetUri) {
        return new HttpActionBuilder(targetUri);
    }

    public static SlackActionBuilder slackAction(URI targetUri) {
        return new SlackActionBuilder(targetUri);
    }

    public static class HttpActionBuilder {
        private final URI targetUri;
        private final Map<String, Object> httpHeaders = new LinkedHashMap<String, Object>();

        HttpActionBuilder(URI targetUri) {
            this.targetUri = targetUri;
        }

        public HttpActionBuilder addHeader(String key, String value) {
            this.httpHeaders.put(key, value);
            return this;
        }

        public HttpActionBuilder addHeaders(Map<String, String> headers) {
            this.httpHeaders.putAll(headers);
            return this;
        }

        public ReactionDefinition.Action build() {
            return ReactionDefinition.Action.newAction("HTTP_POST", this.targetUri, this.httpHeaders, null);
        }
    }

    public static class SlackActionBuilder {
        private final URI webHookUrl;
        private String text;

        SlackActionBuilder(URI webHookUrl) {
            this.webHookUrl = webHookUrl;
        }

        public SlackActionBuilder text(String text) {
            this.text = text;
            return this;
        }

        public ReactionDefinition.Action build() {
            return ReactionDefinition.Action.newAction("SLACK_POST", this.webHookUrl, Collections.emptyMap(), this.text);
        }
    }
}

