/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.feed;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.serialized.client.SerializedClientConfig;
import io.serialized.client.SerializedOkHttpClient;
import io.serialized.client.feed.Feed;
import io.serialized.client.feed.FeedEntry;
import io.serialized.client.feed.FeedEntryHandler;
import io.serialized.client.feed.FeedResponse;
import io.serialized.client.feed.FeedsResponse;
import io.serialized.client.feed.RetryException;
import java.io.Closeable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ValueRange;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class FeedClient
implements Closeable {
    private static final String SEQUENCE_NUMBER_HEADER = "Serialized-SequenceNumber-Current";
    private static final ValueRange SUBSCRIPTION_POLL_DELAY_VALUE_RANGE = ValueRange.of(1L, 60L);
    private final SerializedOkHttpClient client;
    private final HttpUrl apiRoot;
    private final Set<ExecutorService> executors = new HashSet<ExecutorService>();

    private FeedClient(Builder builder) {
        this.client = new SerializedOkHttpClient(builder.httpClient, builder.objectMapper);
        this.apiRoot = builder.apiRoot;
    }

    public static Builder feedClient(SerializedClientConfig config) {
        return new Builder(config);
    }

    public List<Feed> listFeeds() {
        HttpUrl url = this.apiRoot.newBuilder().addPathSegment("feeds").build();
        return this.client.get(url, FeedsResponse.class).feeds();
    }

    public long getCurrentGlobalSequenceNumber() {
        HttpUrl url = this.apiRoot.newBuilder().addPathSegment("feeds").addPathSegment("_all").build();
        return this.client.head(url, response -> Long.parseLong(Objects.requireNonNull(response.header(SEQUENCE_NUMBER_HEADER))));
    }

    public long getCurrentSequenceNumber(String feedName) {
        HttpUrl url = this.apiRoot.newBuilder().addPathSegment("feeds").addPathSegment(feedName).build();
        return this.client.head(url, response -> Long.parseLong(Objects.requireNonNull(response.header(SEQUENCE_NUMBER_HEADER))));
    }

    public FeedRequest feed(String feedName) {
        return new FeedRequest(feedName);
    }

    public FeedRequest all() {
        return new FeedRequest("_all");
    }

    @Override
    public void close() {
        this.executors.forEach(ExecutorService::shutdown);
    }

    public static class Builder {
        private final OkHttpClient httpClient;
        private final ObjectMapper objectMapper;
        private final HttpUrl apiRoot;

        Builder(SerializedClientConfig config) {
            this.httpClient = config.httpClient();
            this.objectMapper = config.objectMapper();
            this.apiRoot = config.apiRoot();
        }

        public FeedClient build() {
            return new FeedClient(this);
        }
    }

    public class FeedRequest {
        private Integer limit;
        private String feedName;
        private Duration pollDelay = Duration.ofSeconds(1L);
        private boolean eagerFetching = true;

        private FeedRequest(String feedName) {
            this.feedName = feedName;
        }

        public FeedRequest limit(int limit) {
            this.limit = limit;
            return this;
        }

        public FeedRequest eagerFetching(boolean eagerFetching) {
            this.eagerFetching = eagerFetching;
            return this;
        }

        public FeedRequest subscriptionPollDelay(Duration pollDelay) {
            if (SUBSCRIPTION_POLL_DELAY_VALUE_RANGE.isValidValue(pollDelay.get(ChronoUnit.SECONDS))) {
                this.pollDelay = pollDelay;
                return this;
            }
            throw new IllegalArgumentException(String.format("Poll delay must be within %d and %d seconds", SUBSCRIPTION_POLL_DELAY_VALUE_RANGE.getMinimum(), SUBSCRIPTION_POLL_DELAY_VALUE_RANGE.getMaximum()));
        }

        public FeedResponse execute(long since) {
            return FeedClient.this.client.get(this.url().addQueryParameter("since", String.valueOf(since)).build(), FeedResponse.class);
        }

        public void execute(long since, FeedEntryHandler feedEntryHandler) {
            FeedResponse response;
            long offset = since;
            do {
                response = this.execute(offset);
                for (FeedEntry feedEntry : response.entries()) {
                    feedEntryHandler.handle(feedEntry);
                    offset = feedEntry.sequenceNumber();
                }
            } while (this.eagerFetching && response.hasMore());
        }

        public void subscribe(FeedEntryHandler feedEntryHandler) {
            this.subscribe(0L, feedEntryHandler);
        }

        public void subscribe(long since, FeedEntryHandler feedEntryHandler) {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            AtomicLong offset = new AtomicLong(since);
            executor.scheduleWithFixedDelay(() -> {
                FeedResponse response;
                do {
                    response = this.execute(offset.get());
                    for (FeedEntry feedEntry : response.entries()) {
                        try {
                            feedEntryHandler.handle(feedEntry);
                            offset.set(feedEntry.sequenceNumber());
                        }
                        catch (RetryException retryException) {}
                    }
                } while (this.eagerFetching && response.hasMore());
            }, this.pollDelay.getSeconds(), this.pollDelay.getSeconds(), TimeUnit.SECONDS);
            FeedClient.this.executors.add(executor);
        }

        private HttpUrl.Builder url() {
            HttpUrl.Builder url = FeedClient.this.apiRoot.newBuilder().addPathSegment("feeds").addPathSegment(this.feedName);
            Optional.ofNullable(this.limit).ifPresent(limit -> url.addQueryParameter("limit", String.valueOf(limit)));
            return url;
        }
    }
}

