/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.aggregate;

import io.serialized.client.aggregate.Event;
import io.serialized.client.aggregate.EventHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class StateBuilder<T> {
    private final Class<T> stateClass;
    private final Map<String, EventHandler<T, ?>> handlers = new LinkedHashMap();

    private StateBuilder(Class<T> stateClass, Map<String, EventHandler<T, ?>> handlers) {
        this.stateClass = stateClass;
        this.handlers.putAll(handlers);
    }

    public static <T> StateBuilder<T> stateBuilder(Class<T> stateClass) {
        return new StateBuilder<T>(stateClass, new LinkedHashMap());
    }

    public static <T> StateBuilder<T> stateBuilder(Class<T> stateClass, Map<String, EventHandler<T, ?>> handlers) {
        return new StateBuilder<T>(stateClass, handlers);
    }

    public <E> StateBuilder<T> withHandler(Class<E> eventClass, EventHandler<T, E> handler) {
        this.handlers.put(eventClass.getSimpleName(), handler);
        return this;
    }

    public T buildState(List<? extends Event> events) {
        try {
            AtomicReference<T> data = new AtomicReference<T>(this.stateClass.newInstance());
            events.forEach(e -> {
                String simpleName = e.getData().getClass().getSimpleName();
                EventHandler handler = this.handlers.get(simpleName);
                if (handler == null) {
                    throw new IllegalStateException("No matching handler for event type: " + simpleName);
                }
                T handle = handler.handle(data.get(), (Event<?>)e);
                data.set(handle);
            });
            return data.get();
        }
        catch (IllegalAccessException | InstantiationException e2) {
            throw new RuntimeException("Failed to build State", e2);
        }
    }
}

