/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.sentry.Baggage;
import io.sentry.BaggageHeader;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryLevel;
import io.sentry.SentrySpanStorage;
import io.sentry.SentryTraceHeader;
import io.sentry.exception.InvalidSentryTraceHeaderException;
import io.sentry.opentelemetry.SentryOtelKeys;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryPropagator
implements TextMapPropagator {
    @NotNull
    private static final List<String> FIELDS = Arrays.asList("sentry-trace", "baggage");
    @NotNull
    private final SentrySpanStorage spanStorage = SentrySpanStorage.getInstance();
    @NotNull
    private final IHub hub;

    public SentryPropagator() {
        this((IHub)HubAdapter.getInstance());
    }

    SentryPropagator(@NotNull IHub hub) {
        this.hub = hub;
    }

    public Collection<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        @NotNull Span otelSpan = Span.fromContext((Context)context);
        @NotNull SpanContext otelSpanContext = otelSpan.getSpanContext();
        if (!otelSpanContext.isValid()) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not injecting Sentry tracing information for invalid OpenTelemetry span.", new Object[0]);
            return;
        }
        @Nullable ISpan sentrySpan = this.spanStorage.get(otelSpanContext.getSpanId());
        if (sentrySpan == null || sentrySpan.isNoOp()) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not injecting Sentry tracing information for span %s as no Sentry span has been found or it is a NoOp (trace %s). This might simply mean this is a request to Sentry.", new Object[]{otelSpanContext.getSpanId(), otelSpanContext.getTraceId()});
            return;
        }
        @NotNull SentryTraceHeader sentryTraceHeader = sentrySpan.toSentryTrace();
        setter.set(carrier, sentryTraceHeader.getName(), sentryTraceHeader.getValue());
        @Nullable BaggageHeader baggageHeader = sentrySpan.toBaggageHeader(Collections.emptyList());
        if (baggageHeader != null) {
            setter.set(carrier, baggageHeader.getName(), baggageHeader.getValue());
        }
    }

    public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter) {
        @Nullable String sentryTraceString = getter.get(carrier, "sentry-trace");
        if (sentryTraceString == null) {
            return context;
        }
        try {
            SentryTraceHeader sentryTraceHeader = new SentryTraceHeader(sentryTraceString);
            SpanContext otelSpanContext = SpanContext.createFromRemoteParent((String)sentryTraceHeader.getTraceId().toString(), (String)sentryTraceHeader.getSpanId().toString(), (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
            @NotNull Context modifiedContext = context.with(SentryOtelKeys.SENTRY_TRACE_KEY, (Object)sentryTraceHeader);
            @Nullable String baggageString = getter.get(carrier, "baggage");
            Baggage baggage = Baggage.fromHeader((String)baggageString);
            modifiedContext = modifiedContext.with(SentryOtelKeys.SENTRY_BAGGAGE_KEY, (Object)baggage);
            Span wrappedSpan = Span.wrap((SpanContext)otelSpanContext);
            modifiedContext = modifiedContext.with((ImplicitContextKeyed)wrappedSpan);
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Continuing Sentry trace %s", new Object[]{sentryTraceHeader.getTraceId()});
            return modifiedContext;
        }
        catch (InvalidSentryTraceHeaderException e) {
            this.hub.getOptions().getLogger().log(SentryLevel.ERROR, "Unable to extract Sentry tracing information from invalid header.", (Throwable)e);
            return context;
        }
    }
}

