/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.TraceId;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.Instrumenter;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentrySpanStorage;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.protocol.SentryId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OpenTelemetryLinkErrorEventProcessor
implements EventProcessor {
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentrySpanStorage spanStorage = SentrySpanStorage.getInstance();

    public OpenTelemetryLinkErrorEventProcessor() {
        this((IHub)HubAdapter.getInstance());
    }

    @TestOnly
    OpenTelemetryLinkErrorEventProcessor(@NotNull IHub hub) {
        this.hub = hub;
    }

    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        @NotNull Instrumenter instrumenter = this.hub.getOptions().getInstrumenter();
        if (Instrumenter.OTEL.equals((Object)instrumenter)) {
            @NotNull Span otelSpan = Span.current();
            @NotNull String traceId = otelSpan.getSpanContext().getTraceId();
            @NotNull String spanId = otelSpan.getSpanContext().getSpanId();
            if (TraceId.isValid((CharSequence)traceId) && io.opentelemetry.api.trace.SpanId.isValid((CharSequence)spanId)) {
                @Nullable ISpan sentrySpan = this.spanStorage.get(spanId);
                if (sentrySpan != null) {
                    @NotNull SpanContext sentrySpanSpanContext = sentrySpan.getSpanContext();
                    @NotNull String operation = sentrySpanSpanContext.getOperation();
                    @Nullable SpanId parentSpanId = sentrySpanSpanContext.getParentSpanId();
                    @NotNull SpanContext spanContext = new SpanContext(new SentryId(traceId), new SpanId(spanId), operation, parentSpanId, null);
                    event.getContexts().setTrace(spanContext);
                    this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Linking Sentry event %s to span %s created via OpenTelemetry (trace %s).", new Object[]{event.getEventId(), spanId, traceId});
                } else {
                    this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not linking Sentry event %s to any transaction created via OpenTelemetry as none has been found for span %s (trace %s).", new Object[]{event.getEventId(), spanId, traceId});
                }
            } else {
                this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not linking Sentry event %s to any transaction created via OpenTelemetry as traceId %s or spanId %s are invalid.", new Object[]{event.getEventId(), traceId, spanId});
            }
        } else {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not linking Sentry event %s to any transaction created via OpenTelemetry as instrumenter is set to %s.", new Object[]{event.getEventId(), instrumenter});
        }
        return event;
    }
}

