/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.sms.response;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import java.util.ArrayList;
import java.util.List;

public class GetRepeats
extends SendonResponse {
    public GetRepeatsData data = new GetRepeatsData();

    public GetRepeats(SendonJsonResponse sendonJsonResponse) {
        super(sendonJsonResponse);
        this.data.cursor = this.getStringValue(sendonJsonResponse.dataJson, "cursor");
        for (JsonElement element : sendonJsonResponse.dataJson.getAsJsonArray("items")) {
            this.data.repeats.add(this.parseRepeatItem(element.getAsJsonObject()));
        }
    }

    private RepeatItem parseRepeatItem(JsonObject item) {
        RepeatItem listItem = new RepeatItem();
        listItem.groupId = this.getStringValue(item, "groupId");
        listItem.repeatId = this.getStringValue(item, "repeatId");
        listItem.repeatStatus = this.getEnumValue(item, "repeatStatus", RepeatStatus.class);
        listItem.cancelRequestTime = this.getStringValue(item, "cancelRequestTime");
        listItem.cancelRequestIp = this.getStringValue(item, "cancelRequestIp");
        listItem.cancelTime = this.getStringValue(item, "cancelTime");
        listItem.repeatSendTime = this.getStringValue(item, "repeatSendTime");
        listItem.messageCount = this.getIntValue(item, "messagesCount");
        listItem.standbyCount = this.getIntValue(item, "standbyCount");
        listItem.succeededCount = this.getIntValue(item, "succeededCount");
        listItem.failedCount = this.getIntValue(item, "failedCount");
        listItem.canceledCount = this.getIntValue(item, "canceledCount");
        listItem.sendingCount = this.getIntValue(item, "sendingCount");
        return listItem;
    }

    public static class GetRepeatsData {
        public List<RepeatItem> repeats = new ArrayList<RepeatItem>();
        public String cursor = "";
    }

    public static class RepeatItem {
        public String groupId;
        public String repeatId;
        public RepeatStatus repeatStatus;
        public String cancelRequestTime;
        public String cancelRequestIp;
        public String cancelTime;
        public String repeatSendTime;
        public int messageCount;
        public int standbyCount;
        public int succeededCount;
        public int failedCount;
        public int canceledCount;
        public int sendingCount;
    }

    public static enum RepeatStatus {
        RESERVED("RESERVED"),
        PROCESSING("PROCESSING"),
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        CANCELED("CANCELED");

        public final String repeatStatus;

        private RepeatStatus(String repeatStatus) {
            this.repeatStatus = repeatStatus;
        }
    }
}

