/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.sender.response;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import java.util.ArrayList;
import java.util.List;

public class GetUserNumbers
extends SendonResponse {
    public GetUserNumbersData data;

    public GetUserNumbers(SendonJsonResponse sendonJsonResponse) {
        super(sendonJsonResponse);
        GetUserNumbersData data = new GetUserNumbersData();
        ArrayList<GetUserNumberItem> userNumberList = new ArrayList<GetUserNumberItem>();
        for (JsonElement element : sendonJsonResponse.dataJson.getAsJsonArray("list")) {
            JsonObject item = element.getAsJsonObject();
            userNumberList.add(this.parseUserNumberItem(item));
        }
        data.list = userNumberList;
        this.data = data;
    }

    private GetUserNumberItem parseUserNumberItem(JsonObject item) {
        GetUserNumberItem listItem = new GetUserNumberItem();
        listItem.numberId = this.getIntValue(item, "numberId");
        listItem.userId = this.getIntValue(item, "userId");
        listItem.channelId = this.getIntValue(item, "channelId");
        listItem.senderNumber = this.getStringValue(item, "senderNumber");
        listItem.numberType = this.getEnumValue(item, "numberType", NumberType.class);
        listItem.senderStatus = this.getEnumValue(item, "senderStatus", SenderStatus.class);
        listItem.rejectType = this.getEnumValue(item, "rejectType", RejectType.class);
        listItem.isDefault = this.getBooleanValue(item, "isDefault", YorN.Y);
        listItem.displayName = this.getStringValue(item, "displayName");
        listItem.isDuplicatedNumber = this.getIntValue(item, "isDuplicatedNumber") == 1;
        listItem.numberContractorType = this.getEnumValue(item, "numberContractorType", ContractorType.class);
        listItem.companyId = this.getIntValue(item, "companyId");
        listItem.companyName = this.getStringValue(item, "companyName");
        listItem.isHidden = this.getBooleanValue(item, "isHidden", YorN.Y);
        listItem.createdAt = this.getStringValue(item, "createdAt");
        listItem.updatedAt = this.getStringValue(item, "updatedAt");
        return listItem;
    }

    public static enum ContractorType {
        COMPANY("COMPANY"),
        COMPANY_EMPLOYEE("COMPANY_EMPLOYEE"),
        COMPANY_CEO("COMPANY_CEO"),
        OTHER_COMPANY("OTHER_COMPANY");

        public final String contractorType;

        private ContractorType(String contractorType) {
            this.contractorType = contractorType;
        }
    }

    public static class GetUserNumberItem {
        int numberId;
        int userId;
        int channelId;
        String senderNumber;
        NumberType numberType;
        SenderStatus senderStatus;
        RejectType rejectType;
        boolean isDefault;
        String displayName;
        boolean isDuplicatedNumber;
        ContractorType numberContractorType;
        int companyId;
        String companyName;
        boolean isHidden;
        String createdAt;
        String updatedAt;
    }

    public static class GetUserNumbersData {
        List<GetUserNumberItem> list;
    }

    public static enum NumberType {
        MOBILE("MOBILE"),
        LANDLINE("LANDLINE");

        public final String numberType;

        private NumberType(String numberType) {
            this.numberType = numberType;
        }
    }

    public static enum RejectType {
        DOCS("DOCS"),
        REOPEN("REOPEN"),
        NONE("");

        public final String rejectType;

        private RejectType(String rejectType) {
            this.rejectType = rejectType;
        }
    }

    public static enum SenderStatus {
        REGISTERED("REGISTERED"),
        WAITING("WAITING"),
        ACTIVE("ACTIVE"),
        INPROGRESS("INPROGRESS"),
        SUSPENDED("SUSPENDED"),
        DENIED("DENIED"),
        REJECTED("REJECTED"),
        FREE("FREE"),
        EXPIRED("EXPIRED");

        public final String senderStatus;

        private SenderStatus(String senderStatus) {
            this.senderStatus = senderStatus;
        }
    }

    public static enum YorN {
        Y("Y"),
        N("N");

        public final String yOrN;

        private YorN(String yOrN) {
            this.yOrN = yOrN;
        }
    }
}

