/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.payment.response;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import java.util.ArrayList;
import java.util.List;

public class GetPaymentHistories
extends SendonResponse {
    public GetPaymentHistoriesData data = new GetPaymentHistoriesData();

    public GetPaymentHistories(SendonJsonResponse sendonJsonResponse) {
        super(sendonJsonResponse);
        this.data.totalCount = this.getIntValue(sendonJsonResponse.dataJson, "totalCount");
        this.data.totalPages = this.getIntValue(sendonJsonResponse.dataJson, "totalPages");
        this.data.currentPage = this.getIntValue(sendonJsonResponse.dataJson, "currentPage");
        this.data.hasNextPage = this.getBooleanValue(sendonJsonResponse.dataJson, "hasNextPage");
        for (JsonElement element : sendonJsonResponse.dataJson.getAsJsonArray("histories")) {
            this.data.histories.add(this.parsePaymentHistoryItem(element.getAsJsonObject()));
        }
    }

    private PaymentHistoryItem parsePaymentHistoryItem(JsonObject item) {
        PaymentHistoryItem listItem = new PaymentHistoryItem();
        listItem.id = this.getIntValue(item, "id");
        listItem.amount = this.getIntValue(item, "amount");
        listItem.chargeStatus = this.getEnumValue(item, "chargeStatus", ChargeStatus.class);
        listItem.chargeMethod = this.getEnumValue(item, "chargeMethod", ChargeMethod.class);
        listItem.proofDocumentType = this.getEnumValue(item, "proofDocumentType", ProofDocumentType.class);
        listItem.proofDocumentId = this.getStringValue(item, "proofDocumentId");
        listItem.memo = this.getStringValue(item, "memo");
        listItem.createdAt = this.getStringValue(item, "createdAt");
        listItem.updatedAt = this.getStringValue(item, "updatedAt");
        listItem.exiredAt = this.getStringValue(item, "exiredAt");
        return listItem;
    }

    public static enum ChargeMethod {
        VACCOUNT("VACCOUNT"),
        CREDIT_CARD("CREDIT_CARD"),
        BANK_TRANSFER("BANK_TRANSFER");

        public final String chargeMethod;

        private ChargeMethod(String chargeMethod) {
            this.chargeMethod = chargeMethod;
        }
    }

    public static enum ChargeStatus {
        CHARGE_COMPLETE("CHARGE_COMPLETE"),
        CANCEL_PENDING("CANCEL_PENDING"),
        CANCEL_FAILED("CANCEL_FAILED"),
        CANCEL_COMPLETE("CANCEL_COMPLETE");

        public final String chargeStatus;

        private ChargeStatus(String chargeStatus) {
            this.chargeStatus = chargeStatus;
        }
    }

    public static class GetPaymentHistoriesData {
        public List<PaymentHistoryItem> histories = new ArrayList<PaymentHistoryItem>();
        public int totalCount;
        public int totalPages;
        public int currentPage;
        public boolean hasNextPage;
    }

    public static class PaymentHistoryItem {
        public int id;
        public int amount;
        public ChargeStatus chargeStatus;
        public ChargeMethod chargeMethod;
        public ProofDocumentType proofDocumentType;
        public String proofDocumentId;
        public String memo;
        public String createdAt;
        public String updatedAt;
        public String exiredAt;
    }

    public static enum ProofDocumentType {
        CASH_RECEIPT("CASH_RECEIPT"),
        TAX_INVOICE("TAX_INVOICE"),
        NONE("NONE");

        public final String proofDocumentType;

        private ProofDocumentType(String proofDocumentType) {
            this.proofDocumentType = proofDocumentType;
        }
    }
}

