/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.payment;

import io.sendon.base.Log;
import io.sendon.base.SendonClient;
import io.sendon.base.SendonJsonResponse;
import io.sendon.payment.response.GetPaymentHistories;
import io.sendon.payment.response.GetPaymentHistory;

public class SendonPayment
extends SendonClient {
    public SendonPayment(String userId, String apiKey) {
        super(userId, apiKey);
    }

    public SendonPayment(String userId, String apiKey, boolean useOkHttp) {
        super(userId, apiKey, useOkHttp);
    }

    public GetPaymentHistories getPaymentHistories(int page, int limit, String startDate, String endDate) {
        Log.d("getPaymentHistories: page=" + page + ", limit=" + limit + ", startDate=" + startDate + ", endDate=" + endDate);
        try {
            SendonJsonResponse sendonJsonResponse = this.parseJsonResponse(this.get("/v2/payment/payment-histories?page=" + page + "&limit=" + limit + (startDate != null ? "&startDate=" + startDate : "") + (endDate != null ? "&endDate=" + endDate : "")).toString());
            return new GetPaymentHistories(sendonJsonResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GetPaymentHistory getPaymentHistory(int historyId) {
        Log.d("getPaymentHistory: historyId=" + historyId);
        try {
            SendonJsonResponse sendonResponse = this.parseJsonResponse(this.get("/v2/payment/payment-histories/" + historyId));
            return new GetPaymentHistory(sendonResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

