/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.sendon.JSON;
import io.sendon.model.PointsList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PointsListResponse {
    public static final String SERIALIZED_NAME_POINTS = "points";
    @SerializedName(value="points")
    private List<PointsList> points = new ArrayList<PointsList>();
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private BigDecimal cursor;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    static {
        openapiFields.add(SERIALIZED_NAME_POINTS);
        openapiFields.add(SERIALIZED_NAME_CURSOR);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_POINTS);
    }

    public PointsListResponse points(List<PointsList> points) {
        this.points = points;
        return this;
    }

    public PointsListResponse addPointsItem(PointsList pointsItem) {
        if (this.points == null) {
            this.points = new ArrayList<PointsList>();
        }
        this.points.add(pointsItem);
        return this;
    }

    @Nonnull
    public List<PointsList> getPoints() {
        return this.points;
    }

    public void setPoints(List<PointsList> points) {
        this.points = points;
    }

    public PointsListResponse cursor(BigDecimal cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    public BigDecimal getCursor() {
        return this.cursor;
    }

    public void setCursor(BigDecimal cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointsListResponse pointsListResponse = (PointsListResponse)o;
        return Objects.equals(this.points, pointsListResponse.points) && Objects.equals(this.cursor, pointsListResponse.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.points, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PointsListResponse {\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PointsListResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PointsListResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_POINTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `points` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POINTS).toString()));
        }
        JsonArray jsonArraypoints = jsonObj.getAsJsonArray(SERIALIZED_NAME_POINTS);
        int i = 0;
        while (i < jsonArraypoints.size()) {
            PointsList.validateJsonElement(jsonArraypoints.get(i));
            ++i;
        }
    }

    public static PointsListResponse fromJson(String jsonString) throws IOException {
        return (PointsListResponse)JSON.getGson().fromJson(jsonString, PointsListResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PointsListResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PointsListResponse.class));
            return new TypeAdapter<PointsListResponse>(){

                public void write(JsonWriter out, PointsListResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PointsListResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PointsListResponse.validateJsonElement(jsonElement);
                    return (PointsListResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

