/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.kakao.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.kakao.request.Template;
import io.sendon.point.response.GetCosts;
import java.util.ArrayList;
import java.util.List;

public class GetTemplates
extends SendonResponse {
    public GetTemplatesData data = new GetTemplatesData();

    public GetTemplates(SendonJsonResponse sendonJsonResponse) {
        super(sendonJsonResponse);
        this.data.templates = new ArrayList<Template>();
        sendonJsonResponse.dataJson.getAsJsonArray("templates").forEach(item -> {
            Template template = new Template();
            template.profileId = this.getStringValue(item.getAsJsonObject(), "profileId");
            template.id = this.getStringValue(item.getAsJsonObject(), "id");
            template.templateName = this.getStringValue(item.getAsJsonObject(), "templateName");
            template.status = this.getStringValue(item.getAsJsonObject(), "status");
            template.templateMessageType = this.getEnumValue(item.getAsJsonObject(), "templateMessageType", Template.TemplateMessageType.class);
            template.templateEmphasizeType = this.getEnumValue(item.getAsJsonObject(), "templateEmphasizeType", Template.TemplateEmphasizeType.class);
            template.templateContent = this.getStringValue(item.getAsJsonObject(), "templateContent");
            template.buttons = new ArrayList<Template.Button>();
            if (item.getAsJsonObject().has("buttons") && !item.getAsJsonObject().get("buttons").isJsonNull()) {
                item.getAsJsonObject().getAsJsonArray("buttons").forEach(buttonItem -> {
                    Template.Button button = new Template.Button();
                    button.type = Template.ButtonType.valueOf(this.getStringValue(buttonItem.getAsJsonObject(), "type"));
                    button.name = this.getStringValue(buttonItem.getAsJsonObject(), "name");
                    button.ordering = this.getIntValue(buttonItem.getAsJsonObject(), "ordering");
                    if (button.type == Template.ButtonType.AL) {
                        Template.AlButton alButton = new Template.AlButton();
                        alButton.schemeIos = this.getStringValue(buttonItem.getAsJsonObject(), "schemeIos");
                        alButton.schemeAndroid = this.getStringValue(buttonItem.getAsJsonObject(), "schemeAndroid");
                    } else if (button.type == Template.ButtonType.WL) {
                        Template.WlButton wlButton = new Template.WlButton();
                        wlButton.urlMobile = this.getStringValue(buttonItem.getAsJsonObject(), "urlMobile");
                        wlButton.urlPc = this.getStringValue(buttonItem.getAsJsonObject(), "urlPc");
                    }
                    template.buttons.add(button);
                });
            }
            template.fallback = new Fallback();
            template.fallback.senderNumber = this.getStringValue(item.getAsJsonObject(), "senderNumber");
            template.fallback.type = this.getEnumValue(item.getAsJsonObject(), "type", GetCosts.MessageType.class);
            template.fallback.message = this.getStringValue(item.getAsJsonObject(), "message");
            template.fallback.title = this.getStringValue(item.getAsJsonObject(), "title");
            template.fallback.images = new ArrayList<String>();
            if (item.getAsJsonObject().has("images") && !item.getAsJsonObject().get("images").isJsonNull()) {
                item.getAsJsonObject().getAsJsonArray("images").forEach(imageItem -> template.fallback.images.add(this.getStringValue(imageItem.getAsJsonObject(), "image")));
            }
            template.fallback.groupId = this.getStringValue(item.getAsJsonObject(), "groupId");
            template.securityFlag = this.getBooleanValue(item.getAsJsonObject(), "securityFlag");
            template.templateComments = new ArrayList<TemplateComment>();
            if (item.getAsJsonObject().has("templateComments") && !item.getAsJsonObject().get("templateComments").isJsonNull()) {
                item.getAsJsonObject().getAsJsonArray("templateComments").forEach(commentItem -> {
                    TemplateComment templateComment = new TemplateComment();
                    templateComment.commentContent = this.getStringValue(commentItem.getAsJsonObject(), "templateContent");
                    templateComment.commentCreateAt = this.getStringValue(commentItem.getAsJsonObject(), "commentCreateAt");
                    templateComment.commentSeqno = this.getStringValue(commentItem.getAsJsonObject(), "commentSeqno");
                    templateComment.commentStatus = this.getStringValue(commentItem.getAsJsonObject(), "commentStatus");
                    templateComment.commentUserName = this.getStringValue(commentItem.getAsJsonObject(), "commentUserName");
                    templateComment.updateBy = this.getStringValue(commentItem.getAsJsonObject(), "updateBy");
                    templateComment.updateDate = this.getStringValue(commentItem.getAsJsonObject(), "updateDate");
                    template.templateComments.add(templateComment);
                });
            }
            template.templateTitle = this.getStringValue(item.getAsJsonObject(), "templateTitle");
            template.templateSubtitle = this.getStringValue(item.getAsJsonObject(), "templateSubtitle");
            template.templateImageName = this.getStringValue(item.getAsJsonObject(), "templateImageName");
            template.templateImageUrl = this.getStringValue(item.getAsJsonObject(), "templateImageUrl");
            template.templateAd = this.getStringValue(item.getAsJsonObject(), "templateAd");
            template.templateExtra = this.getStringValue(item.getAsJsonObject(), "templateExtra");
            template.createdAt = this.getStringValue(item.getAsJsonObject(), "createdAt");
            template.updatedAt = this.getStringValue(item.getAsJsonObject(), "updatedAt");
            template.syncedAt = this.getStringValue(item.getAsJsonObject(), "syncedAt");
            template.lastusedAt = this.getStringValue(item.getAsJsonObject(), "lastusedAt");
            this.data.templates.add(template);
        });
    }

    public static class Fallback {
        public String senderNumber;
        public GetCosts.MessageType type;
        public String message;
        public String title;
        public List<String> images;
        public String groupId;
    }

    public static class GetTemplatesData {
        public List<Template> templates;
    }

    public static class Template {
        public String profileId;
        public String id;
        public String templateName;
        public String status;
        public Template.TemplateMessageType templateMessageType;
        public Template.TemplateEmphasizeType templateEmphasizeType;
        public String templateContent;
        public List<Template.Button> buttons;
        public Fallback fallback;
        public boolean securityFlag;
        public List<TemplateComment> templateComments;
        public String templateTitle;
        public String templateSubtitle;
        public String templateImageName;
        public String templateImageUrl;
        public String templateAd;
        public String templateExtra;
        public String createdAt;
        public String updatedAt;
        public String syncedAt;
        public String lastusedAt;
    }

    public static class TemplateComment {
        public String commentContent;
        public String commentCreateAt;
        public String commentSeqno;
        public String commentStatus;
        public String commentUserName;
        public String updateBy;
        public String updateDate;
    }
}

