/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.kakao.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.kakao.request.Template;
import io.sendon.point.response.GetCosts;
import java.util.ArrayList;
import java.util.List;

public class CreateTemplate
extends SendonResponse {
    public CreateTemplateData data = new CreateTemplateData();

    public CreateTemplate(SendonJsonResponse sendonJsonResponse) {
        super(sendonJsonResponse);
        this.data.profileId = this.getStringValue(sendonJsonResponse.dataJson, "profileId");
        this.data.id = this.getStringValue(sendonJsonResponse.dataJson, "id");
        this.data.templateName = this.getStringValue(sendonJsonResponse.dataJson, "templateName");
        this.data.status = this.getEnumValue(sendonJsonResponse.dataJson, "status", Template.TemplateStatus.class);
        this.data.templateMessageType = this.getEnumValue(sendonJsonResponse.dataJson, "templateMessageType", Template.TemplateMessageType.class);
        this.data.templateEmphasizeType = this.getEnumValue(sendonJsonResponse.dataJson, "templateEmphasizeType", Template.TemplateEmphasizeType.class);
        this.data.templateContent = this.getStringValue(sendonJsonResponse.dataJson, "templateContent");
        this.data.buttons = new ArrayList<Template.Button>();
        sendonJsonResponse.dataJson.getAsJsonArray("buttons").forEach(item -> {
            Template.ButtonType buttonType = this.getEnumValue(item.getAsJsonObject(), "type", Template.ButtonType.class);
            if (buttonType == Template.ButtonType.WL) {
                Template.WlButton button = new Template.WlButton();
                button.type = buttonType;
                button.name = this.getStringValue(item.getAsJsonObject(), "name");
                button.ordering = this.getIntValue(item.getAsJsonObject(), "ordering");
                button.urlMobile = this.getStringValue(item.getAsJsonObject(), "urlMobile");
                button.urlPc = this.getStringValue(item.getAsJsonObject(), "urlPc");
                this.data.buttons.add(button);
            } else if (buttonType == Template.ButtonType.AL) {
                Template.AlButton button = new Template.AlButton();
                button.type = buttonType;
                button.name = this.getStringValue(item.getAsJsonObject(), "name");
                button.ordering = this.getIntValue(item.getAsJsonObject(), "ordering");
                button.schemeIos = this.getStringValue(item.getAsJsonObject(), "schemeIos");
                button.schemeAndroid = this.getStringValue(item.getAsJsonObject(), "schemeAndroid");
                this.data.buttons.add(button);
            } else {
                Template.Button button = new Template.Button();
                button.type = buttonType;
                button.name = this.getStringValue(item.getAsJsonObject(), "name");
                button.ordering = this.getIntValue(item.getAsJsonObject(), "ordering");
                this.data.buttons.add(button);
            }
        });
        this.data.fallback = new Fallback();
        this.data.fallback.senderNumber = this.getStringValue(sendonJsonResponse.dataJson, "fallback.senderNumber");
        this.data.fallback.type = this.getEnumValue(sendonJsonResponse.dataJson, "fallback.type", GetCosts.MessageType.class);
        this.data.fallback.message = this.getStringValue(sendonJsonResponse.dataJson, "fallback.message");
        this.data.fallback.title = this.getStringValue(sendonJsonResponse.dataJson, "fallback.title");
        if (sendonJsonResponse.dataJson.has("fallback.images") && sendonJsonResponse.dataJson.get("fallback.images").isJsonArray()) {
            sendonJsonResponse.dataJson.getAsJsonArray("fallback.images").forEach(item -> this.data.fallback.images.add(this.getStringValue(item.getAsJsonObject(), "url")));
        }
        this.data.fallback.groupId = this.getStringValue(sendonJsonResponse.dataJson, "fallback.groupId");
        this.data.securityFlag = this.getBooleanValue(sendonJsonResponse.dataJson, "securityFlag");
        this.data.templateComments = new ArrayList<TemplateComment>();
        if (sendonJsonResponse.dataJson.has("templateComments") && sendonJsonResponse.dataJson.get("templateComments").isJsonArray()) {
            sendonJsonResponse.dataJson.getAsJsonArray("templateComments").forEach(item -> {
                TemplateComment templateComment = new TemplateComment();
                templateComment.commentContent = this.getStringValue(item.getAsJsonObject(), "commentContent");
                templateComment.commentCreateAt = this.getStringValue(item.getAsJsonObject(), "commentCreateAt");
                templateComment.commentSeqno = this.getStringValue(item.getAsJsonObject(), "commentSeqno");
                templateComment.commentStatus = this.getStringValue(item.getAsJsonObject(), "commentStatus");
                templateComment.commentUserName = this.getStringValue(item.getAsJsonObject(), "commentUserName");
                templateComment.updateBy = this.getStringValue(item.getAsJsonObject(), "updateBy");
                templateComment.updateDate = this.getStringValue(item.getAsJsonObject(), "updateDate");
                this.data.templateComments.add(templateComment);
            });
        }
        this.data.templateTitle = this.getStringValue(sendonJsonResponse.dataJson, "templateTitle");
        this.data.templateSubtitle = this.getStringValue(sendonJsonResponse.dataJson, "templateSubtitle");
        this.data.templateImageName = this.getStringValue(sendonJsonResponse.dataJson, "templateImageName");
        this.data.templateImageUrl = this.getStringValue(sendonJsonResponse.dataJson, "templateImageUrl");
        this.data.templateAd = this.getStringValue(sendonJsonResponse.dataJson, "templateAd");
        this.data.templateExtra = this.getStringValue(sendonJsonResponse.dataJson, "templateExtra");
        this.data.createdAt = this.getStringValue(sendonJsonResponse.dataJson, "createdAt");
        this.data.updatedAt = this.getStringValue(sendonJsonResponse.dataJson, "updatedAt");
        this.data.syncedAt = this.getStringValue(sendonJsonResponse.dataJson, "syncedAt");
        this.data.lastUsedAt = this.getStringValue(sendonJsonResponse.dataJson, "lastUsedAt");
    }

    public static class CreateTemplateData {
        public String profileId;
        public String id;
        public String templateName;
        public Template.TemplateStatus status;
        public Template.TemplateMessageType templateMessageType;
        public Template.TemplateEmphasizeType templateEmphasizeType;
        public String templateContent;
        public List<Template.Button> buttons;
        public Fallback fallback;
        public boolean securityFlag;
        public List<TemplateComment> templateComments;
        public String templateTitle;
        public String templateSubtitle;
        public String templateImageName;
        public String templateImageUrl;
        public String templateAd;
        public String templateExtra;
        public String createdAt;
        public String updatedAt;
        public String syncedAt;
        public String lastUsedAt;
    }

    public static class Fallback {
        public String senderNumber = "";
        public GetCosts.MessageType type = GetCosts.MessageType.SMS;
        public String message = "";
        public String title = "";
        public List<String> images = new ArrayList<String>();
        public String groupId = "";
    }

    public static class TemplateComment {
        public String commentContent;
        public String commentCreateAt;
        public String commentSeqno;
        public String commentStatus;
        public String commentUserName;
        public String updateBy;
        public String updateDate;
    }
}

