/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.contacts;

import com.google.gson.JsonObject;
import io.sendon.base.Log;
import io.sendon.base.SendonClient;
import io.sendon.base.SendonJsonResponse;
import io.sendon.contacts.response.AddBlocklist;
import io.sendon.contacts.response.DeleteBlocklist;
import io.sendon.contacts.response.GetBlocklist;

public class SendonContacts
extends SendonClient {
    public SendonContacts(String userId, String apiKey) {
        super(userId, apiKey);
    }

    public SendonContacts(String userId, String apiKey, boolean useOkHttp) {
        super(userId, apiKey, useOkHttp);
    }

    public AddBlocklist addBlocklist(String phoneNumber) {
        Log.d("addBlocklist: " + phoneNumber);
        JsonObject bodyJson = new JsonObject();
        bodyJson.addProperty("phoneNumber", phoneNumber);
        try {
            SendonJsonResponse sendonResponse = this.parseJsonResponse(this.post("/v2/contacts/blocklist", bodyJson.toString()));
            return new AddBlocklist(sendonResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GetBlocklist getBlocklist(int cursor, int limit) {
        Log.d("getBlocklist: cursor=" + cursor + ", limit=" + limit);
        try {
            SendonJsonResponse sendonResponse = this.parseJsonResponse(this.get("/v2/contacts/blocklist?cursor=" + cursor + "&limit=" + limit));
            return new GetBlocklist(sendonResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DeleteBlocklist deleteBlocklist(int blockId) {
        Log.d("deleteBlocklist: " + blockId);
        JsonObject bodyJson = new JsonObject();
        try {
            SendonJsonResponse sendonResponse = this.parseJsonResponse(this.post("/v2/contacts/blocklist/" + blockId + "/delete", bodyJson.toString()));
            return new DeleteBlocklist(sendonResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

