/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.base;

import io.sendon.base.HttpClient;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SquareupOkHttpClient
extends HttpClient {
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    public SquareupOkHttpClient(String baseUrl, String id, String pw) {
        super(baseUrl, id, pw);
    }

    @Override
    public String post(String endpoint, String body) {
        return this.sendRequest("POST", endpoint, body);
    }

    @Override
    public String put(String endpoint, String body) {
        return this.sendRequest("PUT", endpoint, body);
    }

    @Override
    public String delete(String endpoint) {
        return this.sendRequest("DELETE", endpoint, null);
    }

    @Override
    public String get(String endpoint) {
        return this.sendRequest("GET", endpoint, null);
    }

    @Override
    public String sendRequest(String method, String endpoint, String body) {
        try {
            RequestBody requestBody = RequestBody.create((String)(body != null ? body : "{}"), (MediaType)JSON);
            Request.Builder requestBuilder = new Request.Builder().url(String.valueOf(this.baseUrl) + endpoint).header("Authorization", this.authBasic);
            switch (method) {
                case "POST": {
                    requestBuilder.post(requestBody);
                    break;
                }
                case "PUT": {
                    requestBuilder.put(requestBody);
                    break;
                }
                case "DELETE": {
                    requestBuilder.delete();
                    break;
                }
                case "GET": {
                    requestBuilder.get();
                }
            }
            Object object = null;
            Object var7_9 = null;
            try (Response response = this.client.newCall(requestBuilder.build()).execute();){
                return response.body().string();
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String postImagesWithMultipartFormData(String path, List<File> images) {
        try {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            for (File image : images) {
                builder.addFormDataPart("images", image.getName(), RequestBody.create((File)image, (MediaType)MediaType.parse((String)"image/png")));
            }
            MultipartBody requestBody = builder.build();
            Request request = new Request.Builder().url(String.valueOf(this.baseUrl) + path).header("Authorization", this.authBasic).post((RequestBody)requestBody).build();
            Throwable throwable = null;
            Object var7_9 = null;
            try (Response response = this.client.newCall(request).execute();){
                return response.body().string();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String postImageWithMulStringFormData(String path, File image) {
        try {
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("image", image.getName(), RequestBody.create((File)image, (MediaType)MediaType.parse((String)"image/png"))).build();
            Request request = new Request.Builder().url(String.valueOf(this.baseUrl) + path).header("Authorization", this.authBasic).post((RequestBody)requestBody).build();
            Throwable throwable = null;
            Object var6_8 = null;
            try (Response response = this.client.newCall(request).execute();){
                return response.body().string();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

