/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.sendon.base.ApacheHttpClient;
import io.sendon.base.HttpClient;
import io.sendon.base.Log;
import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SquareupOkHttpClient;
import java.io.File;
import java.util.List;

public class SendonClient {
    protected HttpClient httpClient;
    protected Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SendonClient(String userId, String apiKey) {
        String baseUrl = System.getProperty("base.url", "https://dev-api.sendon.io");
        this.httpClient = new SquareupOkHttpClient(baseUrl, userId, apiKey);
    }

    public SendonClient(String userId, String apiKey, boolean useOkHttp) {
        String baseUrl = System.getProperty("base.url", "https://dev-api.sendon.io");
        this.httpClient = useOkHttp ? new SquareupOkHttpClient(baseUrl, userId, apiKey) : new ApacheHttpClient(baseUrl, userId, apiKey);
    }

    public SendonClient(String baseUrl, String userId, String apiKey, boolean useOkHttp) {
        this.httpClient = useOkHttp ? new SquareupOkHttpClient(baseUrl, userId, apiKey) : new ApacheHttpClient(baseUrl, userId, apiKey);
    }

    public String get(String path) {
        return this.httpClient.get(path);
    }

    public String post(String path, String body) {
        return this.httpClient.post(path, body);
    }

    public String put(String path, String body) {
        return this.httpClient.put(path, body);
    }

    public String delete(String path) {
        return this.httpClient.delete(path);
    }

    public String postImageWithMultipartFormData(String path, File image) {
        return this.httpClient.postImageWithMulStringFormData(path, image);
    }

    public String postImagesWithMultipartFormData(String path, List<File> images) {
        return this.httpClient.postImagesWithMultipartFormData(path, images);
    }

    public SendonJsonResponse parseJsonResponse(String jsonResponse) {
        Log.d("JsonResponse: " + this.gson.toJson((Object)jsonResponse));
        JsonObject jsonObject = JsonParser.parseString((String)jsonResponse).getAsJsonObject();
        int code = jsonObject.get("code").getAsInt();
        String message = jsonObject.get("message").getAsString();
        JsonObject data = null;
        if (jsonObject.get("data") != null) {
            data = jsonObject.get("data").getAsJsonObject();
        }
        SendonJsonResponse sendonJsonResponse = new SendonJsonResponse(code, message, data);
        Log.d("SendonJsonResponse: " + this.gson.toJson((Object)sendonJsonResponse));
        return sendonJsonResponse;
    }
}

