/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.base;

import io.sendon.base.HttpClient;
import io.sendon.base.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;

public class ApacheHttpClient
extends HttpClient {
    public ApacheHttpClient(String baseUrl, String id, String pw) {
        super(baseUrl, id, pw);
    }

    @Override
    public String post(String endpoint, String body) {
        return this.sendRequest("POST", endpoint, body);
    }

    @Override
    public String put(String endpoint, String body) {
        return this.sendRequest("PUT", endpoint, body);
    }

    @Override
    public String delete(String endpoint) {
        return this.sendRequest("DELETE", endpoint, null);
    }

    @Override
    public String get(String endpoint) {
        return this.sendRequest("GET", endpoint, null);
    }

    @Override
    public String sendRequest(String method, String endpoint, String body) {
        try {
            int responseCode;
            InputStream responseStream;
            URL url = new URL(String.valueOf(this.baseUrl) + endpoint);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestMethod(method);
            conn.setRequestProperty("Authorization", this.authBasic);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(body != null);
            if (body != null) {
                Throwable throwable = null;
                Object var7_12 = null;
                try (OutputStream os = conn.getOutputStream();){
                    os.write(body.getBytes());
                    os.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            InputStream inputStream = responseStream = (responseCode = conn.getResponseCode()) >= 400 ? conn.getErrorStream() : conn.getInputStream();
            if (responseStream != null) {
                Throwable throwable = null;
                Object var9_16 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
                    return reader.lines().reduce("", (a, b) -> String.valueOf(a) + b);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            return "";
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String postImagesWithMultipartFormData(String path, List<File> images) {
        Log.d("postImagesWithMultipartFormData: " + path);
        String boundary = UUID.randomUUID().toString();
        String LINE_FEED = "\r\n";
        try {
            InputStream responseStream;
            URL url = new URL(String.valueOf(this.baseUrl) + path);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", this.authBasic);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            conn.setDoOutput(true);
            Throwable throwable = null;
            Object var8_13 = null;
            try (OutputStream os = conn.getOutputStream();){
                for (File image : images) {
                    String contentType = "image/png";
                    StringBuilder sb = new StringBuilder();
                    sb.append("--").append(boundary).append(LINE_FEED);
                    sb.append("Content-Disposition: form-data; name=\"images\"; filename=\"").append(image.getName()).append("\"").append(LINE_FEED);
                    sb.append("Content-Type: ").append(contentType).append(LINE_FEED);
                    sb.append(LINE_FEED);
                    os.write(sb.toString().getBytes());
                    Files.copy(image.toPath(), os);
                    os.write(LINE_FEED.getBytes());
                }
                os.write(("--" + boundary + "--").getBytes());
                os.write(LINE_FEED.getBytes());
                os.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int responseCode = conn.getResponseCode();
            InputStream inputStream = responseStream = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
            if (responseStream != null) {
                Throwable throwable3 = null;
                Object var10_18 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
                    return reader.lines().reduce("", (a, b) -> String.valueOf(a) + b);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            return "";
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String postImageWithMulStringFormData(String path, File image) {
        Log.d("postImageWithMulStringFormData: " + path);
        String boundary = UUID.randomUUID().toString();
        String LINE_FEED = "\r\n";
        try {
            InputStream responseStream;
            URL url = new URL(String.valueOf(this.baseUrl) + path);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", this.authBasic);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            conn.setDoOutput(true);
            Throwable throwable = null;
            Object var8_13 = null;
            try (OutputStream os = conn.getOutputStream();){
                StringBuilder sb = new StringBuilder();
                sb.append("--").append(boundary).append(LINE_FEED);
                sb.append("Content-Disposition: form-data; name=\"image\"; filename=\"").append(image.getName()).append("\"").append(LINE_FEED);
                sb.append("Content-Type: ").append("image/png").append(LINE_FEED);
                sb.append(LINE_FEED);
                os.write(sb.toString().getBytes());
                Files.copy(image.toPath(), os);
                os.write(LINE_FEED.getBytes());
                os.write(("--" + boundary + "--").getBytes());
                os.write(LINE_FEED.getBytes());
                os.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int responseCode = conn.getResponseCode();
            InputStream inputStream = responseStream = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
            if (responseStream != null) {
                Throwable throwable3 = null;
                Object var10_17 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
                    return reader.lines().reduce("", (a, b) -> String.valueOf(a) + b);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            return "";
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

