/*
 * Decompiled with CFR 0.152.
 */
package io.sendon.api;

import com.google.gson.reflect.TypeToken;
import io.sendon.ApiCallback;
import io.sendon.ApiClient;
import io.sendon.ApiException;
import io.sendon.ApiResponse;
import io.sendon.Configuration;
import io.sendon.Pair;
import io.sendon.model.GetPaymentHistoriesResponse;
import io.sendon.model.GetPaymentHistoryResponse;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SdoPayment {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SdoPayment() {
        this(Configuration.getDefaultApiClient());
    }

    public SdoPayment(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getPaymentHistoriesCall(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/payment/payment-histories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentHistoriesValidateBeforeCall(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        return this.getPaymentHistoriesCall(page, limit, startDate, endDate, _callback);
    }

    public GetPaymentHistoriesResponse getPaymentHistories(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        ApiResponse<GetPaymentHistoriesResponse> localVarResp = this.getPaymentHistoriesWithHttpInfo(page, limit, startDate, endDate);
        return localVarResp.getData();
    }

    public ApiResponse<GetPaymentHistoriesResponse> getPaymentHistoriesWithHttpInfo(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        Call localVarCall = this.getPaymentHistoriesValidateBeforeCall(page, limit, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<GetPaymentHistoriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPaymentHistoriesAsync(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback<GetPaymentHistoriesResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentHistoriesValidateBeforeCall(page, limit, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentHistoriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPaymentHistoryCall(BigDecimal historyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/payment/payment-histories/{historyId}".replace("{historyId}", this.localVarApiClient.escapeString(historyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentHistoryValidateBeforeCall(BigDecimal historyId, ApiCallback _callback) throws ApiException {
        if (historyId == null) {
            throw new ApiException("Missing the required parameter 'historyId' when calling getPaymentHistory(Async)");
        }
        return this.getPaymentHistoryCall(historyId, _callback);
    }

    public GetPaymentHistoryResponse getPaymentHistory(BigDecimal historyId) throws ApiException {
        ApiResponse<GetPaymentHistoryResponse> localVarResp = this.getPaymentHistoryWithHttpInfo(historyId);
        return localVarResp.getData();
    }

    public ApiResponse<GetPaymentHistoryResponse> getPaymentHistoryWithHttpInfo(BigDecimal historyId) throws ApiException {
        Call localVarCall = this.getPaymentHistoryValidateBeforeCall(historyId, null);
        Type localVarReturnType = new TypeToken<GetPaymentHistoryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPaymentHistoryAsync(BigDecimal historyId, ApiCallback<GetPaymentHistoryResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentHistoryValidateBeforeCall(historyId, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentHistoryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

