/*
 * Decompiled with CFR 0.152.
 */
package io.sendon;

import io.sendon.base.Log;
import io.sendon.contacts.SendonContacts;
import io.sendon.kakao.SendonKakao;
import io.sendon.payment.SendonPayment;
import io.sendon.point.SendonPoint;
import io.sendon.sender.SendonSender;
import io.sendon.sms.SendonSms;

public class Sendon {
    private static Sendon instance = null;
    public final SendonContacts contacts;
    public final SendonPoint point;
    public final SendonSender sender;
    public final SendonPayment payment;
    public final SendonSms sms;
    public final SendonKakao kakao;

    private Sendon(String id, String apiKey, boolean debug) {
        this.contacts = new SendonContacts(id, apiKey);
        this.point = new SendonPoint(id, apiKey);
        this.sender = new SendonSender(id, apiKey);
        this.payment = new SendonPayment(id, apiKey);
        this.sms = new SendonSms(id, apiKey);
        this.kakao = new SendonKakao(id, apiKey);
        Log.debug = debug;
        Log.warn = debug;
        Log.error = debug;
        Log.info = debug;
    }

    public static Sendon getInstance(String id, String apiKey) {
        return Sendon.getInstance(id, apiKey, false);
    }

    public static Sendon getInstance(String id, String apiKey, boolean debug) {
        if (instance == null) {
            instance = new Sendon(id, apiKey, debug);
        }
        return instance;
    }

    public SendonContacts getContacts() {
        return this.contacts;
    }

    public SendonPoint getPoint() {
        return this.point;
    }

    public SendonSender getSender() {
        return this.sender;
    }

    public SendonPayment getPayment() {
        return this.payment;
    }

    public SendonSms getSms() {
        return this.sms;
    }

    public SendonKakao getKakao() {
        return this.kakao;
    }
}

