package io.sendon.sms.response;

import java.lang.reflect.Type;
import java.util.List;

import io.sendon.base.Log;
import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

public class UploadImage extends SendonResponse {
  public UploadImageData data;

  public static class Image {
    public String id;
    public int size;
    public String filename;
  }

  public static class UploadImageData {
    public List<Image> images;
  }

  public UploadImage(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    Log.d("UploadImageResponse: " + sendonJsonResponse.dataJson.toString());
    Type type = new TypeToken<UploadImageData>(){}.getType();
    this.data = new Gson().fromJson(sendonJsonResponse.dataJson, type);
  }
}
