package io.sendon.sms.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.sms.SendonSms.MessageType;

public class GetGroup extends SendonResponse {
  public GetGroupData data;

  public enum ReservedStatus {
    NONE("NONE"),
    RESERVED("RESERVED"),
    PROCESSING("PROCESSING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    CANCELED("CANCELED");

    public final String value;

    ReservedStatus(String reservedStatus) {
      this.value = reservedStatus;
    }
  }

  public enum GroupStatus {
    NONE("NONE"),
    RESERVED("RESERVED"),
    PROCESSING("PROCESSING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    CANCELED("CANCELED");

    public final String value;

    GroupStatus(String groupStatus) {
      this.value = groupStatus;
    }
  }

  public enum immediatelyAction {
    NONE("NONE"),
    CANCEL("CANCEL"),
    SEND("SEND");

    public final String immediatelyAction;

    immediatelyAction(String immediatelyAction) {
      this.immediatelyAction = immediatelyAction;
    }
  }

  public static class GetGroupData {
    public String groupId;
    public String channelId;
    public int countRequest;
    public String message;
    public MessageType messageType;
    public String requestIp;
    public int userId;
    public boolean isUseApi;
    public int repeatCount;
    public int repeatInterval;
    public String repeatUnit;
    public int messageCount;
    public int standbyCount;
    public int sendingCount;
    public int succeededCount;
    public int failedCount;
    public int canceledCount;
    public int blockedCount;
    public int pointId;
    public float totalPoint;
    public float vatPoint;
    public float unitCost;
    public float refundPoint;
    public GroupStatus groupStatus;
    public String createdAt;
    public immediatelyAction immediatelyAction;
    public String senderNumber;
    public boolean isAd;
    public ReservedStatus reservedStatus;
  }

  public GetGroup(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    this.data = new GetGroupData();
    this.data.groupId = getStringValue(sendonJsonResponse.dataJson, "groupId");
    this.data.channelId = getStringValue(sendonJsonResponse.dataJson, "channelId");
    this.data.countRequest = getIntValue(sendonJsonResponse.dataJson, "countRequest");
    this.data.message = getStringValue(sendonJsonResponse.dataJson, "message");
    this.data.requestIp = getStringValue(sendonJsonResponse.dataJson, "requestIp");
    this.data.userId = getIntValue(sendonJsonResponse.dataJson, "userId");
    this.data.isUseApi = getBooleanValue(sendonJsonResponse.dataJson, "isUseApi");
    this.data.repeatCount = getIntValue(sendonJsonResponse.dataJson, "repeatCount");
    this.data.repeatInterval = getIntValue(sendonJsonResponse.dataJson, "repeatInterval");
    this.data.repeatUnit = getStringValue(sendonJsonResponse.dataJson, "repeatUnit");
    this.data.messageCount = getIntValue(sendonJsonResponse.dataJson, "messageCount");
    this.data.standbyCount = getIntValue(sendonJsonResponse.dataJson, "standbyCount");
    this.data.sendingCount = getIntValue(sendonJsonResponse.dataJson, "sendingCount");
    this.data.succeededCount = getIntValue(sendonJsonResponse.dataJson, "succeededCount");
    this.data.failedCount = getIntValue(sendonJsonResponse.dataJson, "failedCount");
    this.data.canceledCount = getIntValue(sendonJsonResponse.dataJson, "canceledCount");
    this.data.blockedCount = getIntValue(sendonJsonResponse.dataJson, "blockedCount");
    this.data.pointId = getIntValue(sendonJsonResponse.dataJson, "pointId");
    this.data.totalPoint = getFloatValue(sendonJsonResponse.dataJson, "totalPoint");
    this.data.vatPoint = getFloatValue(sendonJsonResponse.dataJson, "vatPoint");
    this.data.unitCost = getFloatValue(sendonJsonResponse.dataJson, "unitCost");
    this.data.refundPoint = getFloatValue(sendonJsonResponse.dataJson, "refundPoint");
    this.data.groupStatus = getEnumValue(sendonJsonResponse.dataJson, "groupStatus", GroupStatus.class);
    this.data.createdAt = getStringValue(sendonJsonResponse.dataJson, "createdAt");
    this.data.immediatelyAction = getEnumValue(sendonJsonResponse.dataJson, "immediatelyAction", immediatelyAction.class);
    this.data.senderNumber = getStringValue(sendonJsonResponse.dataJson, "senderNumber");
    this.data.isAd = getBooleanValue(sendonJsonResponse.dataJson, "isAd");
    this.data.reservedStatus = getEnumValue(sendonJsonResponse.dataJson, "reservedStatus", ReservedStatus.class);
  }

}
