package io.sendon.sms.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class CancelGroup extends SendonResponse {
  public CancelGroupData data;

  public static class CancelGroupData {
    public String groupId;
    public int succeeded;
    public int failed;
  }

  public CancelGroup(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    this.data = new CancelGroupData();
    this.data.groupId = getStringValue(sendonJsonResponse.dataJson, "groupId");
    this.data.succeeded = getIntValue(sendonJsonResponse.dataJson, "succeeded");
    this.data.failed = getIntValue(sendonJsonResponse.dataJson, "failed");
  }
}
