package io.sendon.point.response;

import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetPoints extends SendonResponse {
  public GetPointsData data;

  public static class General {
    public int points;
    public int costId;
    public int pointId;
    public int channelId;
    public int userId;
    public String createdAt;
    public String updatedAt;
  }

  public static class Free {
    public int points;
    public int pointId;
    public int userId;
    public String expiredAt;
    public String createdAt;
    public String updatedAt;
  }

  public static class Point {
    public General general;
    public Free free;
  }

  public static class GetPointsData {
    public List<Point> points;
  }

  public GetPoints(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    Type type = new TypeToken<GetPointsData>(){}.getType();
    this.data = new Gson().fromJson(sendonJsonResponse.dataJson, type);
  }

}
