package io.sendon.point;

import io.sendon.base.Log;
import io.sendon.base.SendonClient;
import io.sendon.base.SendonJsonResponse;
import io.sendon.point.response.GetCosts;
import io.sendon.point.response.GetPoints;

public class SendonPoint extends SendonClient {
  public SendonPoint(String userId, String apiKey) {
    super(userId, apiKey);
  }

  public SendonPoint(String userId, String apiKey, boolean useOkHttp) {
    super(userId, apiKey, useOkHttp);
  }

  public GetPoints getPoints() {
    Log.d("getPoints");

    try {
      SendonJsonResponse sendonResponse = parseJsonResponse(get("/v2/point/points"));
      return new GetPoints(sendonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public GetCosts getCosts() {
    Log.d("getCost");

    try {
      SendonJsonResponse sendonResponse = parseJsonResponse(get("/v2/point/costs"));
      return new GetCosts(sendonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }
}
