package io.sendon.payment.response;

import com.google.gson.JsonObject;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.payment.response.GetPaymentHistories.ChargeMethod;
import io.sendon.payment.response.GetPaymentHistories.ChargeStatus;
import io.sendon.payment.response.GetPaymentHistories.ProofDocumentType;

public class GetPaymentHistory extends SendonResponse {
  public GetPaymentHistoryData data;

  public static class GetPaymentHistoryData {
    public int id;
    public int userId;
    public int amount;
    public ChargeStatus chargeStatus;
    public ChargeMethod chargeMethod;
    public ProofDocumentType proofDocumentType;
    public String proofDocumentId;
    public String memo;
    public String createdAt;
    public String updatedAt;
    public String expiredAt;

  }

  public GetPaymentHistory(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    this.data = new GetPaymentHistoryData();
    JsonObject history = sendonJsonResponse.dataJson.getAsJsonObject("history");

    this.data.id = getIntValue(history, "id");
    this.data.userId = getIntValue(history, "userId");
    this.data.amount = getIntValue(history, "amount");
    this.data.chargeStatus = getEnumValue(history, "chargeStatus", ChargeStatus.class);
    this.data.chargeMethod = getEnumValue(history, "chargeMethod", ChargeMethod.class);
    this.data.proofDocumentType = getEnumValue(history, "proofDocumentType", ProofDocumentType.class);
    this.data.proofDocumentId = getStringValue(history, "proofDocumentId");
    this.data.memo = getStringValue(history, "memo");
    this.data.createdAt = getStringValue(history, "createdAt");
    this.data.updatedAt = getStringValue(history, "updatedAt");
    this.data.expiredAt = getStringValue(history, "expiredAt");
  }

}
