package io.sendon.payment.response;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetPaymentHistories extends SendonResponse {
  public GetPaymentHistoriesData data;

  public enum ChargeStatus {
    CHARGE_COMPLETE("CHARGE_COMPLETE"),
    CANCEL_PENDING("CANCEL_PENDING"),
    CANCEL_FAILED("CANCEL_FAILED"),
    CANCEL_COMPLETE("CANCEL_COMPLETE");

    public final String chargeStatus;

    ChargeStatus(String chargeStatus) {
      this.chargeStatus = chargeStatus;
    }
  }

  public enum ChargeMethod {
    VACCOUNT("VACCOUNT"),
    CREDIT_CARD("CREDIT_CARD"),
    BANK_TRANSFER("BANK_TRANSFER");

    public final String chargeMethod;

    ChargeMethod(String chargeMethod) {
      this.chargeMethod = chargeMethod;
    }
  }

  public enum ProofDocumentType {
    CASH_RECEIPT("CASH_RECEIPT"),
    TAX_INVOICE("TAX_INVOICE"),
    NONE("NONE");

    public final String proofDocumentType;

    ProofDocumentType(String proofDocumentType) {
      this.proofDocumentType = proofDocumentType;
    }
  }

  public static class PaymentHistoryItem {
    public int id;
    public int amount;
    public ChargeStatus chargeStatus;
    public ChargeMethod chargeMethod;
    public ProofDocumentType proofDocumentType;
    public String proofDocumentId;
    public String memo;
    public String createdAt;
    public String updatedAt;
    public String exiredAt;
  }

  public static class GetPaymentHistoriesData {
    public List<PaymentHistoryItem> histories;
    public int totalCount;
    public int totalPages;
    public int currentPage;
    public boolean hasNextPage;

    public GetPaymentHistoriesData() {
      this.histories = new ArrayList<>();
    }
  }

  public GetPaymentHistories(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    this.data = new GetPaymentHistoriesData();
    this.data.totalCount = getIntValue(sendonJsonResponse.dataJson, "totalCount");
    this.data.totalPages = getIntValue(sendonJsonResponse.dataJson, "totalPages");
    this.data.currentPage = getIntValue(sendonJsonResponse.dataJson, "currentPage");
    this.data.hasNextPage = getBooleanValue(sendonJsonResponse.dataJson, "hasNextPage");

    for (JsonElement element : sendonJsonResponse.dataJson.getAsJsonArray("histories")) {
      this.data.histories.add(parsePaymentHistoryItem(element.getAsJsonObject()));
    }
  }

  private PaymentHistoryItem parsePaymentHistoryItem(JsonObject item) {
    PaymentHistoryItem listItem = new PaymentHistoryItem();
    listItem.id = getIntValue(item, "id");
    listItem.amount = getIntValue(item, "amount");
    listItem.chargeStatus = getEnumValue(item, "chargeStatus", ChargeStatus.class);
    listItem.chargeMethod = getEnumValue(item, "chargeMethod", ChargeMethod.class);
    listItem.proofDocumentType = getEnumValue(item, "proofDocumentType", ProofDocumentType.class);
    listItem.proofDocumentId = getStringValue(item, "proofDocumentId");
    listItem.memo = getStringValue(item, "memo");
    listItem.createdAt = getStringValue(item, "createdAt");
    listItem.updatedAt = getStringValue(item, "updatedAt");
    listItem.exiredAt = getStringValue(item, "exiredAt");
    return listItem;
  }
}
