package io.sendon.kakao.response;

import java.util.List;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.kakao.request.Template.AlButton;
import io.sendon.kakao.request.Template.Button;
import io.sendon.kakao.request.Template.ButtonType;
import io.sendon.kakao.request.Template.TemplateEmphasizeType;
import io.sendon.kakao.request.Template.TemplateMessageType;
import io.sendon.kakao.request.Template.WlButton;
import io.sendon.point.response.GetCosts.MessageType;

import java.util.ArrayList;

public class GetTemplates extends SendonResponse{
  public GetTemplatesData data;

  public static class Fallback {
    public String senderNumber;
    public MessageType type;
    public String message;
    public String title;
    public List<String> images;
    public String groupId;
  }

  public static class TemplateComment {
    public String commentContent;
    public String commentCreateAt;
    public String commentSeqno;
    public String commentStatus;
    public String commentUserName;
    public String updateBy;
    public String updateDate;
  }

  public static class Template {
    public String profileId;
    public String id;
    public String templateName;
    public String status;
    public TemplateMessageType templateMessageType;
    public TemplateEmphasizeType templateEmphasizeType;
    public String templateContent;
    public List<Button> buttons;
    public Fallback fallback;
    public boolean securityFlag;
    public List<TemplateComment> templateComments;

    public String templateTitle;
    public String templateSubtitle;
    public String templateImageName;
    public String templateImageUrl;
    public String templateAd;
    public String templateExtra;
    public String createdAt;
    public String updatedAt;
    public String syncedAt;
    public String lastusedAt;
  }

  public static class GetTemplatesData {
    public List<Template> templates;
  }

  public GetTemplates(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    this.data = new GetTemplatesData();
    this.data.templates = new ArrayList<>();
    sendonJsonResponse.dataJson.getAsJsonArray("templates").forEach(item -> {
      Template template = new Template();

      template.profileId = getStringValue(item.getAsJsonObject(), "profileId");
      template.id = getStringValue(item.getAsJsonObject(), "id");
      template.templateName = getStringValue(item.getAsJsonObject(), "templateName");
      template.status = getStringValue(item.getAsJsonObject(), "status");
      template.templateMessageType = getEnumValue(item.getAsJsonObject(), "templateMessageType", TemplateMessageType.class);
      template.templateEmphasizeType = getEnumValue(item.getAsJsonObject(), "templateEmphasizeType", TemplateEmphasizeType.class);
      template.templateContent = getStringValue(item.getAsJsonObject(), "templateContent");

      template.buttons = new ArrayList<>();
      if (item.getAsJsonObject().has("buttons") && !item.getAsJsonObject().get("buttons").isJsonNull()) {
        item.getAsJsonObject().getAsJsonArray("buttons").forEach(buttonItem -> {
          Button button = new Button();
          button.type = ButtonType.valueOf(getStringValue(buttonItem.getAsJsonObject(), "type"));
          button.name = getStringValue(buttonItem.getAsJsonObject(), "name");
          button.ordering = getIntValue(buttonItem.getAsJsonObject(), "ordering");

          if (button.type == ButtonType.AL) {
            AlButton alButton = new AlButton();
            alButton.schemeIos = getStringValue(buttonItem.getAsJsonObject(), "schemeIos");
            alButton.schemeAndroid = getStringValue(buttonItem.getAsJsonObject(), "schemeAndroid");
          } else if (button.type == ButtonType.WL) {
            WlButton wlButton = new WlButton();
            wlButton.urlMobile = getStringValue(buttonItem.getAsJsonObject(), "urlMobile");
            wlButton.urlPc = getStringValue(buttonItem.getAsJsonObject(), "urlPc");
          }
          template.buttons.add(button);
        });
      }

      template.fallback = new Fallback();
      template.fallback.senderNumber = getStringValue(item.getAsJsonObject(), "senderNumber");
      template.fallback.type = getEnumValue(item.getAsJsonObject(), "type", MessageType.class);
      template.fallback.message = getStringValue(item.getAsJsonObject(), "message");
      template.fallback.title = getStringValue(item.getAsJsonObject(), "title");
      template.fallback.images = new ArrayList<>();
      if (item.getAsJsonObject().has("images") && !item.getAsJsonObject().get("images").isJsonNull()) {
        item.getAsJsonObject().getAsJsonArray("images").forEach(imageItem -> {
          template.fallback.images.add(getStringValue(imageItem.getAsJsonObject(), "image"));
        });
      }
      template.fallback.groupId = getStringValue(item.getAsJsonObject(), "groupId");

      template.securityFlag = getBooleanValue(item.getAsJsonObject(), "securityFlag");
      template.templateComments = new ArrayList<>();
      if (item.getAsJsonObject().has("templateComments") && !item.getAsJsonObject().get("templateComments").isJsonNull()) {
        item.getAsJsonObject().getAsJsonArray("templateComments").forEach(commentItem -> {
          TemplateComment templateComment = new TemplateComment();
          templateComment.commentContent = getStringValue(commentItem.getAsJsonObject(), "templateContent");
          templateComment.commentCreateAt = getStringValue(commentItem.getAsJsonObject(), "commentCreateAt");
          templateComment.commentSeqno = getStringValue(commentItem.getAsJsonObject(), "commentSeqno");
          templateComment.commentStatus = getStringValue(commentItem.getAsJsonObject(), "commentStatus");
          templateComment.commentUserName = getStringValue(commentItem.getAsJsonObject(), "commentUserName");
          templateComment.updateBy = getStringValue(commentItem.getAsJsonObject(), "updateBy");
          templateComment.updateDate = getStringValue(commentItem.getAsJsonObject(), "updateDate");

          template.templateComments.add(templateComment);
        });
      }

      template.templateTitle = getStringValue(item.getAsJsonObject(), "templateTitle");
      template.templateSubtitle = getStringValue(item.getAsJsonObject(), "templateSubtitle");
      template.templateImageName = getStringValue(item.getAsJsonObject(), "templateImageName");
      template.templateImageUrl = getStringValue(item.getAsJsonObject(), "templateImageUrl");
      template.templateAd = getStringValue(item.getAsJsonObject(), "templateAd");
      template.templateExtra = getStringValue(item.getAsJsonObject(), "templateExtra");
      template.createdAt = getStringValue(item.getAsJsonObject(), "createdAt");
      template.updatedAt = getStringValue(item.getAsJsonObject(), "updatedAt");
      template.syncedAt = getStringValue(item.getAsJsonObject(), "syncedAt");
      template.lastusedAt = getStringValue(item.getAsJsonObject(), "lastusedAt");

      this.data.templates.add(template);
    });
  }

}
