package io.sendon.kakao.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetProfileDetail extends SendonResponse {
  public GetProfileDetailData data;

  public static class GetProfileDetailData {
    public String id;
    public String channelId;
    public String channelName;
    public String status;
    public String profileStatus;
    public String updateBy;
    public boolean dormant;
    public boolean block;
    public String createdAt;
    public String updatedAt;
  }

  public GetProfileDetail(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    this.data = new GetProfileDetailData();
    this.data.id = getStringValue(sendonJsonResponse.dataJson, "id");
    this.data.channelId = getStringValue(sendonJsonResponse.dataJson, "channelId");
    this.data.channelName = getStringValue(sendonJsonResponse.dataJson, "channelName");
    this.data.status = getStringValue(sendonJsonResponse.dataJson, "status");
    this.data.profileStatus = getStringValue(sendonJsonResponse.dataJson, "profileStatus");
    this.data.updateBy = getStringValue(sendonJsonResponse.dataJson, "updateBy");
    this.data.dormant = getBooleanValue(sendonJsonResponse.dataJson, "dormant");
    this.data.block = getBooleanValue(sendonJsonResponse.dataJson, "block");
    this.data.createdAt = getStringValue(sendonJsonResponse.dataJson, "createdAt");
    this.data.updatedAt = getStringValue(sendonJsonResponse.dataJson, "updatedAt");
  }

}
