package io.sendon.kakao.response;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonObject;

import io.sendon.base.Log;
import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.point.response.GetCosts.MessageType;

public class GetGroup extends SendonResponse {
  public GetGroupData data;

  public enum ReservedStatus {
    NONE("NONE"),
    RESERVED("RESERVED"),
    PROCESSING("PROCESSING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    CANCELED("CANCELED");

    public final String value;

    ReservedStatus(String reservedStatus) {
      this.value = reservedStatus;
    }
  }

  public enum GroupStatus {
    NONE("NONE"),
    RESERVED("RESERVED"),
    PROCESSING("PROCESSING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    CANCELED("CANCELED");

    public final String value;

    GroupStatus(String groupStatus) {
      this.value = groupStatus;
    }
  }

  public static class Fallback {
    public MessageType type;
    public boolean isAd;
    public String senderNumber;
    public String message;
    public String title;
    public List<String> images;
    public String groupId;

    public Fallback() {
      this.images = new ArrayList<>();
    }
  }

  public static class Button {
    public String name;
    public String linkMobile;
    public String linkPc;
    public String schemeIos;
    public String schemeAndroid;
    public String additionalProp1;
    public String additionalProp2;
    public String additionalProp3;
  }

  public static class AT {
    public String body;
    public List<Button> buttons;
    public String templateId;
    public String templateExtra;
    public String templateAd;

    public AT() {
      this.buttons = new ArrayList<>();
    }
  }

  public static class AE {
    public String body;
    public List<Button> buttons;
    public String templateId;
    public String templateExtra;
    public String templateAd;
    public String templateTitle;
    public String templateSubtitle;

    public AE() {
      this.buttons = new ArrayList<>();
    }
  }

  public static class AI {
    public String body;
    public List<Button> buttons;
    public String templateId;
    public String templateExtra;
    public String templateAd;
    public String templateImageUrl;

    public AI() {
      this.buttons = new ArrayList<>();
    }
  }

  public static class FT {
    public String body;
    public List<Button> buttons;
    public boolean isAd;

    public FT() {
      this.buttons = new ArrayList<>();
    }
  }

  public static class FI {
    public String body;
    public List<Button> buttons;
    public boolean isAd;
    public String imageUrl;

    public FI() {
      this.buttons = new ArrayList<>();
    }
  }

  public static class FW {
    public String body;
    public List<Button> buttons;
    public boolean isAd;
    public String imageUrl;

    public FW() {
      this.buttons = new ArrayList<>();
    }
  }

  public static class MessageContents {
    public MessageType messageType;
    public AT at;
    public AE ae;
    public AI ai;
    public FT ft;
    public FI fi;
    public FW fw;

    public MessageContents() {

    }
  }

  public static class GetGroupData {
    public int userId;
    public String profileId;
    public String groupId;
    public String message;
    public MessageType messageType;
    public String requestDomain;
    public String sender;
    public ReservedStatus reservedStatus;
    public GroupStatus groupStatus;
    public int countRequest;
    public int messageCount;
    public int standbyCount;
    public int sendingCount;
    public int succeededCount;
    public int failedCount;
    public int canceledCount;
    public int fallbackCount;
    public float unitCost;
    public float vatPoint;
    public float totalPoint;
    public float refundPoint;
    public Fallback fallback;
    public MessageContents messageContents;
    public boolean isUseApi;
    public String createdAt;
    public String updatedAt;
  }

  public GetGroup(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    this.data = new GetGroupData();
    this.data.userId = getIntValue(sendonJsonResponse.dataJson, "userId");
    this.data.profileId = getStringValue(sendonJsonResponse.dataJson, "profileId");
    this.data.groupId = getStringValue(sendonJsonResponse.dataJson, "groupId");
    this.data.message = getStringValue(sendonJsonResponse.dataJson, "message");
    this.data.messageType = getEnumValue(sendonJsonResponse.dataJson, "messageType", MessageType.class);
    this.data.requestDomain = getStringValue(sendonJsonResponse.dataJson, "requestDomain");
    this.data.sender = getStringValue(sendonJsonResponse.dataJson, "sender");
    this.data.reservedStatus = getEnumValue(sendonJsonResponse.dataJson, "reservedStatus", ReservedStatus.class);
    this.data.groupStatus = getEnumValue(sendonJsonResponse.dataJson, "groupStatus", GroupStatus.class);
    this.data.countRequest = getIntValue(sendonJsonResponse.dataJson, "countRequest");
    this.data.messageCount = getIntValue(sendonJsonResponse.dataJson, "messageCount");
    this.data.standbyCount = getIntValue(sendonJsonResponse.dataJson, "standbyCount");
    this.data.sendingCount = getIntValue(sendonJsonResponse.dataJson, "sendingCount");
    this.data.succeededCount = getIntValue(sendonJsonResponse.dataJson, "succeededCount");
    this.data.failedCount = getIntValue(sendonJsonResponse.dataJson, "failedCount");
    this.data.canceledCount = getIntValue(sendonJsonResponse.dataJson, "canceledCount");
    this.data.fallbackCount = getIntValue(sendonJsonResponse.dataJson, "fallbackCount");
    this.data.unitCost = getFloatValue(sendonJsonResponse.dataJson, "unitCost");
    this.data.vatPoint = getFloatValue(sendonJsonResponse.dataJson, "vatPoint");
    this.data.totalPoint = getFloatValue(sendonJsonResponse.dataJson, "totalPoint");
    this.data.refundPoint = getFloatValue(sendonJsonResponse.dataJson, "refundPoint");

    this.data.fallback = new Fallback();

    if (sendonJsonResponse.dataJson.has("fallback")) {
      JsonObject fallback = sendonJsonResponse.dataJson.getAsJsonObject("fallback");
      this.data.fallback.type = getEnumValue(fallback, "type", MessageType.class);
      this.data.fallback.isAd = getBooleanValue(fallback, "isAd");
      this.data.fallback.senderNumber = getStringValue(fallback, "senderNumber");
      this.data.fallback.message = getStringValue(fallback, "message");
      this.data.fallback.title = getStringValue(fallback, "title");
      this.data.fallback.groupId = getStringValue(sendonJsonResponse.dataJson, "groupId");
      this.data.fallback.images = new ArrayList<>();
      if (fallback.getAsJsonArray("images") != null) {
        fallback.getAsJsonArray("images").forEach(item -> {
          this.data.fallback.images.add(getStringValue(item.getAsJsonObject(), "url"));
        });
      }
    }

    if (sendonJsonResponse.dataJson.has("messageContents")) {
      this.data.messageContents = new MessageContents();
      JsonObject messageContents = sendonJsonResponse.dataJson.getAsJsonObject("messageContents");
      this.data.messageContents.messageType = getEnumValue(messageContents, "messageType", MessageType.class);

      if (this.data.messageContents.messageType == MessageType.AT) {
        JsonObject at = sendonJsonResponse.dataJson.getAsJsonObject("messageContents").getAsJsonObject("AT");
        if (at != null) {
          this.data.messageContents.at = new AT();
          this.data.messageContents.at.body = getStringValue(at, "body");
          this.data.messageContents.at.templateId = getStringValue(at, "templateId");
          this.data.messageContents.at.templateExtra = getStringValue(at, "templateExtra");
          this.data.messageContents.at.templateAd = getStringValue(at, "templateAd");

          if (at.getAsJsonArray("buttons") != null) {
            at.getAsJsonArray("buttons").forEach(item -> {
              Button button = new Button();
              button.name = getStringValue(item.getAsJsonObject(), "name");
              button.linkMobile = getStringValue(item.getAsJsonObject(), "linkMobile");
              button.linkPc = getStringValue(item.getAsJsonObject(), "linkPc");
              button.schemeIos = getStringValue(item.getAsJsonObject(), "schemeIos");
              button.schemeAndroid = getStringValue(item.getAsJsonObject(), "schemeAndroid");
              button.additionalProp1 = getStringValue(item.getAsJsonObject(), "additionalProp1");
              button.additionalProp2 = getStringValue(item.getAsJsonObject(), "additionalProp2");
              button.additionalProp3 = getStringValue(item.getAsJsonObject(), "additionalProp3");
              this.data.messageContents.at.buttons.add(button);
            });
          }
        }
      } else if (this.data.messageContents.messageType == MessageType.AE) {
        JsonObject ae = sendonJsonResponse.dataJson.getAsJsonObject("messageContents").getAsJsonObject("AE");
        if (ae != null) {
          this.data.messageContents.ae = new AE();
          this.data.messageContents.ae.body = getStringValue(ae, "body");
          this.data.messageContents.ae.templateId = getStringValue(ae, "templateId");
          this.data.messageContents.ae.templateExtra = getStringValue(ae, "templateExtra");
          this.data.messageContents.ae.templateAd = getStringValue(ae, "templateAd");
          this.data.messageContents.ae.templateTitle = getStringValue(ae, "templateTitle");
          this.data.messageContents.ae.templateSubtitle = getStringValue(ae, "templateSubtitle");

          if (ae.getAsJsonArray("buttons") != null) {
            ae.getAsJsonArray("buttons").forEach(item -> {
              Button button = new Button();
              button.name = getStringValue(item.getAsJsonObject(), "name");
              button.linkMobile = getStringValue(item.getAsJsonObject(), "linkMobile");
              button.linkPc = getStringValue(item.getAsJsonObject(), "linkPc");
              button.schemeIos = getStringValue(item.getAsJsonObject(), "schemeIos");
              button.schemeAndroid = getStringValue(item.getAsJsonObject(), "schemeAndroid");
              button.additionalProp1 = getStringValue(item.getAsJsonObject(), "additionalProp1");
              button.additionalProp2 = getStringValue(item.getAsJsonObject(), "additionalProp2");
              button.additionalProp3 = getStringValue(item.getAsJsonObject(), "additionalProp3");
              this.data.messageContents.ae.buttons.add(button);
            });
          }
        }
      } else if (this.data.messageContents.messageType == MessageType.AI) {
        JsonObject ai = sendonJsonResponse.dataJson.getAsJsonObject("messageContents").getAsJsonObject("AI");
        if (ai != null) {
          this.data.messageContents.ai = new AI();
          this.data.messageContents.ai.body = getStringValue(ai, "body");
          this.data.messageContents.ai.templateId = getStringValue(ai, "templateId");
          this.data.messageContents.ai.templateExtra = getStringValue(ai, "templateExtra");
          this.data.messageContents.ai.templateAd = getStringValue(ai, "templateAd");
          this.data.messageContents.ai.templateImageUrl = getStringValue(ai, "templateImageUrl");

          if (ai.getAsJsonArray("buttons") != null) {
            ai.getAsJsonArray("buttons").forEach(item -> {
              Button button = new Button();
              button.name = getStringValue(item.getAsJsonObject(), "name");
              button.linkMobile = getStringValue(item.getAsJsonObject(), "linkMobile");
              button.linkPc = getStringValue(item.getAsJsonObject(), "linkPc");
              button.schemeIos = getStringValue(item.getAsJsonObject(), "schemeIos");
              button.schemeAndroid = getStringValue(item.getAsJsonObject(), "schemeAndroid");
              button.additionalProp1 = getStringValue(item.getAsJsonObject(), "additionalProp1");
              button.additionalProp2 = getStringValue(item.getAsJsonObject(), "additionalProp2");
              button.additionalProp3 = getStringValue(item.getAsJsonObject(), "additionalProp3");
              this.data.messageContents.ai.buttons.add(button);
            });
          }
        }
      } else if (this.data.messageContents.messageType == MessageType.FT) {
        JsonObject ft = sendonJsonResponse.dataJson.getAsJsonObject("messageContents").getAsJsonObject("FT");
        if (ft != null) {
          this.data.messageContents.ft = new FT();
          this.data.messageContents.ft.body = getStringValue(ft, "body");
          this.data.messageContents.ft.isAd = getBooleanValue(ft, "isAd");

          if (ft.getAsJsonArray("buttons") != null) {
            ft.getAsJsonArray("buttons").forEach(item -> {
              Button button = new Button();
              button.name = getStringValue(item.getAsJsonObject(), "name");
              button.linkMobile = getStringValue(item.getAsJsonObject(), "linkMobile");
              button.linkPc = getStringValue(item.getAsJsonObject(), "linkPc");
              button.schemeIos = getStringValue(item.getAsJsonObject(), "schemeIos");
              button.schemeAndroid = getStringValue(item.getAsJsonObject(), "schemeAndroid");
              button.additionalProp1 = getStringValue(item.getAsJsonObject(), "additionalProp1");
              button.additionalProp2 = getStringValue(item.getAsJsonObject(), "additionalProp2");
              button.additionalProp3 = getStringValue(item.getAsJsonObject(), "additionalProp3");
            });
          }
        }
      } else if (this.data.messageContents.messageType == MessageType.FI) {
        JsonObject fi = sendonJsonResponse.dataJson.getAsJsonObject("messageContents").getAsJsonObject("FI");
        if (fi != null) {
          this.data.messageContents.fi = new FI();
          this.data.messageContents.fi.body = getStringValue(fi, "body");
          this.data.messageContents.fi.isAd = getBooleanValue(fi, "isAd");
          this.data.messageContents.fi.imageUrl = getStringValue(fi, "imageUrl");

          if (fi.getAsJsonArray("buttons") != null) {
            fi.getAsJsonArray("buttons").forEach(item -> {
              Button button = new Button();
              button.name = getStringValue(item.getAsJsonObject(), "name");
              button.linkMobile = getStringValue(item.getAsJsonObject(), "linkMobile");
              button.linkPc = getStringValue(item.getAsJsonObject(), "linkPc");
              button.schemeIos = getStringValue(item.getAsJsonObject(), "schemeIos");
              button.schemeAndroid = getStringValue(item.getAsJsonObject(), "schemeAndroid");
              button.additionalProp1 = getStringValue(item.getAsJsonObject(), "additionalProp1");
              button.additionalProp2 = getStringValue(item.getAsJsonObject(), "additionalProp2");
              button.additionalProp3 = getStringValue(item.getAsJsonObject(), "additionalProp3");
            });
          }
        }
      } else if (this.data.messageContents.messageType == MessageType.FW) {
        JsonObject fw = sendonJsonResponse.dataJson.getAsJsonObject("messageContents").getAsJsonObject("FW");
        if (fw != null) {
          this.data.messageContents.fw = new FW();
          this.data.messageContents.fw.body = getStringValue(fw, "body");
          this.data.messageContents.fw.isAd = getBooleanValue(fw, "isAd");
          this.data.messageContents.fw.imageUrl = getStringValue(fw, "imageUrl");

          if (fw.getAsJsonArray("buttons") != null) {
            fw.getAsJsonArray("buttons").forEach(item -> {
              Button button = new Button();
              button.name = getStringValue(item.getAsJsonObject(), "name");
              button.linkMobile = getStringValue(item.getAsJsonObject(), "linkMobile");
              button.linkPc = getStringValue(item.getAsJsonObject(), "linkPc");
              button.schemeIos = getStringValue(item.getAsJsonObject(), "schemeIos");
              button.schemeAndroid = getStringValue(item.getAsJsonObject(), "schemeAndroid");
              button.additionalProp1 = getStringValue(item.getAsJsonObject(), "additionalProp1");
              button.additionalProp2 = getStringValue(item.getAsJsonObject(), "additionalProp2");
              button.additionalProp3 = getStringValue(item.getAsJsonObject(), "additionalProp3");
            });
          }
        }
      }
    }
    this.data.isUseApi = getBooleanValue(sendonJsonResponse.dataJson, "isUseApi");
    this.data.createdAt = getStringValue(sendonJsonResponse.dataJson, "createdAt");
    this.data.updatedAt = getStringValue(sendonJsonResponse.dataJson, "updatedAt");
  }

}
