package io.sendon.kakao.request;

import java.util.ArrayList;
import java.util.List;

public class Template {

  public enum TemplateMessageType {
    BA("BA"),
    EX("EX"),
    AD("AD"),
    MI("MI");

    public final String value;

    TemplateMessageType(String value) {
      this.value = value;
    }
  }

  public enum TemplateEmphasizeType {
    TEXT("TEXT"),
    IMAGE("IMAGE"),
    ITEM_LIST("ITEM_LIST"),
    NONE("NONE");

    public final String value;

    TemplateEmphasizeType(String value) {
      this.value = value;
    }
  }

  public enum ButtonType {
    WL("WL"),
    AL("AL"),
    DS("DS"),
    BK("BK"),
    AC("AC"),
    MD("MD");

    public final String value;

    ButtonType(String value) {
      this.value = value;
    }
  }

  public static class Button {
    public String name;
    public int ordering;
    public ButtonType type;
  }

  public static class WlButton extends Button {
    public String urlMobile;
    public String urlPc;
  }

  public static class AlButton extends WlButton {
    public String schemeIos;
    public String schemeAndroid;
  }

  public enum TemplateStatus {
    NEED_PREVIEW("NEED_PREVIEW"),
    IN_PREVIEW("IN_PREVIEW"),
    APPROVED("APPROVED"),
    REJECTED("REJECTED"),
    DORMANT("DORMANT"),
    DELETED("DELETED"),
    UNKNOWN("UNKNOWN");

    public final String value;

    TemplateStatus(String status) {
      this.value = status;
    }
  }

  public enum TemplateQuerySort {
    CREATED_AT("CREATED_AT"),
    RECENT_USED("RECENT_USED");

    public final String querySort;

    TemplateQuerySort(String sort) {
      this.querySort = sort;
    }
  }

  public String templateName;
  public String templateContent;
  public TemplateMessageType templateMessageType;
  public TemplateEmphasizeType templateEmphasizeType;
  public String templateExtra;
  public String templateAd;
  public String templateTitle;
  public String templateSubtitle;
  public boolean securityFlag;
  public String templateImageName;
  public String templateImageUrl;
  public List<Button> buttons;

  public Template() {
    this.templateName = "";
    this.templateContent = "";
    this.templateExtra = "";
    this.templateAd = "";
    this.templateTitle = "";
    this.templateSubtitle = "";
    this.securityFlag = false;
    this.templateImageName = "";
    this.templateImageUrl = "";
    this.buttons = new ArrayList<>();
  }

  public Template setTemplateName(String templateName) {
    this.templateName = templateName;
    return this;
  }

  public Template setTemplateContent(String templateContent) {
    this.templateContent = templateContent;
    return this;
  }

  public Template setTemplateMessageType(TemplateMessageType templateMessageType) {
    this.templateMessageType = templateMessageType;
    return this;
  }

  public Template setTemplateEmphasizeType(TemplateEmphasizeType templateEmphasizeType) {
    this.templateEmphasizeType = templateEmphasizeType;
    return this;
  }

  public Template setTemplateExtra(String templateExtra) {
    this.templateExtra = templateExtra;
    return this;
  }

  public Template setTemplateAd(String templateAd) {
    this.templateAd = templateAd;
    return this;
  }

  public Template setTemplateTitle(String templateTitle) {
    this.templateTitle = templateTitle;
    return this;
  }

  public Template setTemplateSubtitle(String templateSubtitle) {
    this.templateSubtitle = templateSubtitle;
    return this;
  }

  public Template setSecurityFlag(boolean securityFlag) {
    this.securityFlag = securityFlag;
    return this;
  }

  public Template setTemplateImageName(String templateImageName) {
    this.templateImageName = templateImageName;
    return this;
  }

  public Template setTemplateImageUrl(String templateImageUrl) {
    this.templateImageUrl = templateImageUrl;
    return this;
  }

  public Template addButton(Button button) {
    this.buttons.add(button);
    return this;
  }
}