package io.sendon.kakao;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import io.sendon.base.SendonClient;
import io.sendon.base.SendonJsonResponse;
import io.sendon.kakao.request.Fallback;
import io.sendon.kakao.request.Profile;
import io.sendon.kakao.request.Template;
import io.sendon.kakao.request.Template.AlButton;
import io.sendon.kakao.request.Template.Button;
import io.sendon.kakao.request.Template.TemplateQuerySort;
import io.sendon.kakao.request.Template.TemplateStatus;
import io.sendon.kakao.request.Template.WlButton;
import io.sendon.kakao.response.CancelGroup;
import io.sendon.kakao.response.CancelReviewTemplate;
import io.sendon.kakao.response.CreateTemplate;
import io.sendon.kakao.response.DeleteTemplate;
import io.sendon.kakao.response.GetGroup;
import io.sendon.kakao.response.GetProfileDetail;
import io.sendon.kakao.response.GetProfiles;
import io.sendon.kakao.response.GetTemplateDetail;
import io.sendon.kakao.response.GetTemplates;
import io.sendon.kakao.response.RegisterProfile;
import io.sendon.kakao.response.RequestAuthToken;
import io.sendon.kakao.response.RequestReviewTemplate;
import io.sendon.kakao.response.SendAlimtalk;
import io.sendon.kakao.response.SendFriendtalk;
import io.sendon.kakao.response.SendGroup;
import io.sendon.kakao.response.UpdateTemplate;
import io.sendon.kakao.response.UploadAlimtalkImage;
import io.sendon.kakao.response.UploadFallbackImage;
import io.sendon.kakao.response.UploadFriendtalkImage;
import io.sendon.kakao.response.UploadFriendtalkWideImage;
import io.sendon.point.response.GetCosts.MessageType;

public class SendonKakao extends SendonClient {

  public static class Reservation {
    String datetime;
  }

  public static class ToWithVariable {
    String phone;
    Object variables;
  }

  public static class Image {
    public String url;
    public String link;
  }

  public SendonKakao(String userId, String apiKey) {
    super(userId, apiKey);
  }

  public SendonKakao(String userId, String apiKey, boolean useOkHttp) {
    super(userId, apiKey, useOkHttp);
  }

  public RequestAuthToken requestAuthToken(String channelId, String phoneNumber) {
    JsonObject bodyJson = new JsonObject();
    bodyJson.addProperty("channelId", channelId);
    bodyJson.addProperty("phoneNumber", phoneNumber);

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/send-profiles/request-auth-token", bodyJson.toString()));
      return new RequestAuthToken(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public RegisterProfile registerProfile(Profile profile) {
    JsonObject bodyJson = new JsonObject();
    if(profile.id != null && !profile.id.isEmpty()) bodyJson.addProperty("id", profile.id);
    if(profile.token != null && !profile.token.isEmpty()) bodyJson.addProperty("token", profile.token);
    if(profile.phoneNumber != null && !profile.phoneNumber.isEmpty()) bodyJson.addProperty("phoneNumber", profile.phoneNumber);
    if(profile.channelId != null && !profile.channelId.isEmpty()) bodyJson.addProperty("channelId", profile.channelId);

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/send-profiles/register", bodyJson.toString()));
      return new RegisterProfile(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public GetProfiles getProfiles(int limit, String cursor) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(get("/v2/messages/kakao/send-profiles?limit=" + limit + "&cursor=" + cursor));
      return new GetProfiles(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public GetProfileDetail getProfileDetail(String profileId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(get("/v2/messages/kakao/send-profiles/" + profileId));
      return new GetProfileDetail(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public CreateTemplate createTemplate(String profileId, Template template) {
    JsonObject bodyJson = new JsonObject();
    if (template.templateName != null && !template.templateName.isEmpty()) bodyJson.addProperty("templateName", template.templateName);
    if (template.templateContent != null && !template.templateContent.isEmpty()) bodyJson.addProperty("templateContent", template.templateContent);
    if (template.templateMessageType != null) bodyJson.addProperty("templateMessageType", template.templateMessageType.value);
    if (template.templateEmphasizeType != null) bodyJson.addProperty("templateEmphasizeType", template.templateEmphasizeType.value);
    if (template.templateExtra != null && !template.templateExtra.isEmpty()) bodyJson.addProperty("templateExtra", template.templateExtra);
    if (template.templateAd != null && !template.templateAd.isEmpty()) bodyJson.addProperty("templateAd", template.templateAd);
    if (template.templateTitle != null && !template.templateTitle.isEmpty()) bodyJson.addProperty("templateTitle", template.templateTitle);
    if (template.templateSubtitle != null && !template.templateSubtitle.isEmpty()) bodyJson.addProperty("templateSubtitle", template.templateSubtitle);
    if (template.templateImageName != null && !template.templateImageName.isEmpty()) bodyJson.addProperty("templateImageName", template.templateImageName);
    if (template.templateImageUrl != null && !template.templateImageUrl.isEmpty()) bodyJson.addProperty("templateImageUrl", template.templateImageUrl);
    bodyJson.addProperty("securityFlag", template.securityFlag);

    JsonArray buttonsArray = new JsonArray();
    for (Button button : template.buttons) {
      JsonObject buttonObject = new JsonObject();
      buttonObject.addProperty("name", button.name);
      buttonObject.addProperty("ordering", button.ordering);
      buttonObject.addProperty("type", button.type.value);

      if (button instanceof WlButton) {
        WlButton wlButton = (WlButton) button;
        buttonObject.addProperty("urlMobile", wlButton.urlMobile);
        buttonObject.addProperty("urlPc", wlButton.urlPc);
      } else if (button instanceof AlButton) {
        AlButton alButton = (AlButton) button;
        buttonObject.addProperty("schemeIos", alButton.schemeIos);
        buttonObject.addProperty("schemeAndroid", alButton.schemeAndroid);
      }

      buttonsArray.add(buttonObject);
    }
    bodyJson.add("buttons", buttonsArray);

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/send-profiles/" + profileId + "/templates", bodyJson.toString()));
      return new CreateTemplate(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public GetTemplates getTemplates(String profileId, String keyword, int limit, String cursor, TemplateStatus status, TemplateQuerySort sort) {
    try {
      String query = "";
      if (keyword != null && !keyword.isEmpty()) query += "&keyword=" + keyword;
      if (limit > 0) query += "&limit=" + limit;
      if (cursor != null && !cursor.isEmpty()) query += "&nextCursor=" + cursor;
      if (status != null) query += "&status=" + status.value;
      if (sort != null) query += "&sort=" + sort.querySort;

      SendonJsonResponse sendonJsonResponse = parseJsonResponse(get("/v2/messages/kakao/send-profiles/" + profileId + "/templates?" + query));
      return new GetTemplates(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public DeleteTemplate deleteTemplate(String profileId, String templateId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/send-profiles/" + profileId + "/templates/" + templateId + "/delete", null));
      return new DeleteTemplate(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public UpdateTemplate updateTemplate(String profileId, String templateId, Template template) {
    JsonObject bodyJson = new JsonObject();
    if (template.templateName != null && !template.templateName.isEmpty()) bodyJson.addProperty("templateName", template.templateName);
    if (template.templateContent != null && !template.templateContent.isEmpty()) bodyJson.addProperty("templateContent", template.templateContent);
    if (template.templateMessageType != null) bodyJson.addProperty("templateMessageType", template.templateMessageType.value);
    if (template.templateEmphasizeType != null) bodyJson.addProperty("templateEmphasizeType", template.templateEmphasizeType.value);
    if (template.templateExtra != null && !template.templateExtra.isEmpty()) bodyJson.addProperty("templateExtra", template.templateExtra);
    if (template.templateAd != null && !template.templateAd.isEmpty()) bodyJson.addProperty("templateAd", template.templateAd);
    if (template.templateTitle != null && !template.templateTitle.isEmpty()) bodyJson.addProperty("templateTitle", template.templateTitle);
    if (template.templateSubtitle != null && !template.templateSubtitle.isEmpty()) bodyJson.addProperty("templateSubtitle", template.templateSubtitle);
    if (template.templateImageName != null && !template.templateImageName.isEmpty()) bodyJson.addProperty("templateImageName", template.templateImageName);
    if (template.templateImageUrl != null && !template.templateImageUrl.isEmpty()) bodyJson.addProperty("templateImageUrl", template.templateImageUrl);

    bodyJson.addProperty("securityFlag", template.securityFlag);

    JsonArray buttonsArray = new JsonArray();
    for (Button button : template.buttons) {
      JsonObject buttonObject = new JsonObject();
      buttonObject.addProperty("name", button.name);
      buttonObject.addProperty("ordering", button.ordering);
      buttonObject.addProperty("type", button.type.value);

      if (button instanceof WlButton) {
        WlButton wlButton = (WlButton) button;
        buttonObject.addProperty("urlMobile", wlButton.urlMobile);
        buttonObject.addProperty("urlPc", wlButton.urlPc);
      } else if (button instanceof AlButton) {
        AlButton alButton = (AlButton) button;
        buttonObject.addProperty("schemeIos", alButton.schemeIos);
        buttonObject.addProperty("schemeAndroid", alButton.schemeAndroid);
      }

      buttonsArray.add(buttonObject);
    }
    bodyJson.add("buttons", buttonsArray);

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/send-profiles/" + profileId + "/templates/" + templateId + "/update", bodyJson.toString()));
      return new UpdateTemplate(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public RequestReviewTemplate requestReviewTemplate(String profileId, String templateId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/send-profiles/" + profileId + "/templates/" + templateId + "/review", null));
      return new RequestReviewTemplate(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public CancelReviewTemplate cancelReviewTemplate(String profileId, String templateId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/send-profiles/" + profileId + "/templates/" + templateId + "/review-cancel", null));
      return new CancelReviewTemplate(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public GetTemplateDetail getTemplateDetail(String profileId, String templateId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(get("/v2/messages/kakao/send-profiles/" + profileId + "/templates/" + templateId));
      return new GetTemplateDetail(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public UploadAlimtalkImage uploadAlimtalkImage(File image) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(postImageWithMultipartFormData("/v2/messages/kakao/alimtalk/image", image));
      return new UploadAlimtalkImage(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public UploadFriendtalkImage uploadFriendtalkImage(File image) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(postImageWithMultipartFormData("/v2/messages/kakao/friendtalk/image", image));
      return new UploadFriendtalkImage(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public UploadFriendtalkWideImage uploadFriendtalkWideImage(File image) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(postImageWithMultipartFormData("/v2/messages/kakao/friendtalk/image/wide", image));
      return new UploadFriendtalkWideImage(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public UploadFallbackImage uploadFallbackImage(List<File> images) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(postImagesWithMultipartFormData("/v2/messages/kakao/fallback/image", images));
      return new UploadFallbackImage(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public GetGroup getGroup(String groupId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(get("/v2/messages/kakao/groups/" + groupId));
      return new GetGroup(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public CancelGroup cancelGroup(String groupId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/groups/" + groupId + "/cancel", null));
      return new CancelGroup(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public SendGroup sendGroup(String groupId) {
    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/groups/" + groupId + "/send", null));
      return new SendGroup(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public SendAlimtalk sendAlimtalk(io.sendon.kakao.request.SendAlimtalk alimtalk) {
    JsonObject bodyJson = new JsonObject();
    if (alimtalk.profileId != null && !alimtalk.profileId.isEmpty()) bodyJson.addProperty("sendProfileId", alimtalk.profileId);
    if (alimtalk.templateId != null && !alimtalk.templateId.isEmpty()) bodyJson.addProperty("templateId", alimtalk.templateId);
    bodyJson.add("to", gson.toJsonTree(alimtalk.to));

    if (alimtalk.reservation != null) {
      JsonObject reservationJson = new JsonObject();
      reservationJson.addProperty("datetime", alimtalk.reservation.datetime);
      bodyJson.add("reservation", reservationJson);
    }

    if (alimtalk.fallback != null) {
      JsonObject fallbackJson = new JsonObject();
      fallbackJson.addProperty("fallbackType", alimtalk.fallback.fallbackType.value);
      JsonObject fallbackCustom = new JsonObject();
      fallbackCustom.addProperty("type", alimtalk.fallback.custom.type.value);
      fallbackCustom.addProperty("senderNumber", alimtalk.fallback.custom.senderNumber);
      fallbackCustom.addProperty("isAd", alimtalk.fallback.custom.isAd);
      fallbackCustom.addProperty("message", alimtalk.fallback.custom.message);
      fallbackCustom.addProperty("title", alimtalk.fallback.custom.title);
      fallbackCustom.add("images", gson.toJsonTree(alimtalk.fallback.custom.images));
      fallbackJson.add("custom", fallbackCustom);
      bodyJson.add("fallback", fallbackJson);
    }

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/alim-talk", bodyJson.toString()));
      return new SendAlimtalk(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public SendAlimtalk sendAlimtalk(String profileId, String templateId, List<String> to, Reservation reservation, Fallback fallback) {
    JsonObject bodyJson = new JsonObject();
    if (profileId != null && !profileId.isEmpty()) bodyJson.addProperty("sendProfileId", profileId);
    if (templateId != null && !templateId.isEmpty()) bodyJson.addProperty("templateId", templateId);
    bodyJson.add("to", gson.toJsonTree(to));

    if (reservation != null) {
      JsonObject reservationJson = new JsonObject();
      reservationJson.addProperty("datetime", reservation.datetime);
      bodyJson.add("reservation", reservationJson);
    }

    if (fallback != null) {
      JsonObject fallbackJson = new JsonObject();
      fallbackJson.addProperty("fallbackType", fallback.fallbackType.value);
      JsonObject fallbackCustom = new JsonObject();
      fallbackCustom.addProperty("type", fallback.custom.type.value);
      fallbackCustom.addProperty("senderNumber", fallback.custom.senderNumber);
      fallbackCustom.addProperty("isAd", fallback.custom.isAd);
      fallbackCustom.addProperty("message", fallback.custom.message);
      fallbackCustom.addProperty("title", fallback.custom.title);
      fallbackCustom.add("images", gson.toJsonTree(fallback.custom.images));
      fallbackJson.add("custom", fallbackCustom);
      bodyJson.add("fallback", fallbackJson);
    }

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/alim-talk", bodyJson.toString()));
      return new SendAlimtalk(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public SendAlimtalk sendAlimtalkWithWithVariables(String profileId, String templateId, List<ToWithVariable> to, Reservation reservation, Fallback fallback) {
    JsonObject bodyJson = new JsonObject();
    bodyJson.addProperty("sendProfileId", profileId);
    bodyJson.addProperty("templateId", templateId);
    bodyJson.add("to", gson.toJsonTree(to));

    if (reservation != null) {
      JsonObject reservationJson = new JsonObject();
      reservationJson.addProperty("datetime", reservation.datetime);
      bodyJson.add("reservation", reservationJson);
    }

    if (fallback != null) {
      JsonObject fallbackJson = new JsonObject();
      fallbackJson.addProperty("fallbackType", fallback.fallbackType.value);
      JsonObject fallbackCustom = new JsonObject();
      fallbackCustom.addProperty("type", fallback.custom.type.value);
      fallbackCustom.addProperty("senderNumber", fallback.custom.senderNumber);
      fallbackCustom.addProperty("isAd", fallback.custom.isAd);
      fallbackCustom.addProperty("message", fallback.custom.message);
      fallbackCustom.addProperty("title", fallback.custom.title);
      fallbackCustom.add("images", gson.toJsonTree(fallback.custom.images));
      fallbackJson.add("custom", fallbackCustom);
      bodyJson.add("fallback", fallbackJson);
    }

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/alimtalk", bodyJson.toString()));
      return new SendAlimtalk(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  public SendFriendtalk sendFriendtalk(
      String profileId, String templateId, List<String> to,
      String message, List<Button> buttons, boolean isAd,
      Reservation reservation, Fallback fallback, Image image
  ) {
    JsonObject bodyJson = new JsonObject();
    bodyJson.addProperty("sendProfileId", profileId);
    bodyJson.addProperty("templateId", templateId);
    bodyJson.addProperty("mesageType", MessageType.FT.value);
    bodyJson.add("to", gson.toJsonTree(to));
    bodyJson.addProperty("message", message);
    bodyJson.addProperty("isAd", isAd);

    if (buttons != null) {
      JsonArray buttonsArray = new JsonArray();
      for (Button button : buttons) {
        JsonObject buttonObject = new JsonObject();
        buttonObject.addProperty("name", button.name);
        buttonObject.addProperty("ordering", button.ordering);
        buttonObject.addProperty("type", button.type.value);

        if (button instanceof WlButton) {
          WlButton wlButton = (WlButton) button;
          buttonObject.addProperty("urlMobile", wlButton.urlMobile);
          buttonObject.addProperty("urlPc", wlButton.urlPc);
        } else if (button instanceof AlButton) {
          AlButton alButton = (AlButton) button;
          buttonObject.addProperty("schemeIos", alButton.schemeIos);
          buttonObject.addProperty("schemeAndroid", alButton.schemeAndroid);
        }
        buttonsArray.add(buttonObject);
      }
      bodyJson.add("buttons", buttonsArray);
    }

    if (reservation != null) {
      JsonObject reservationJson = new JsonObject();
      reservationJson.addProperty("datetime", reservation.datetime);
      bodyJson.add("reservation", reservationJson);
    }

    if (fallback != null) {
      JsonObject fallbackJson = new JsonObject();
      fallbackJson.addProperty("fallbackType", fallback.fallbackType.value);
      JsonObject fallbackCustom = new JsonObject();
      fallbackCustom.addProperty("type", fallback.custom.type.value);
      fallbackCustom.addProperty("senderNumber", fallback.custom.senderNumber);
      fallbackCustom.addProperty("isAd", fallback.custom.isAd);
      fallbackCustom.addProperty("message", fallback.custom.message);
      fallbackCustom.addProperty("title", fallback.custom.title);
      fallbackCustom.add("images", gson.toJsonTree(fallback.custom.images));
      fallbackJson.add("custom", fallbackCustom);
      bodyJson.add("fallback", fallbackJson);
    }

    if (image != null) {
      JsonObject imageJson = new JsonObject();
      imageJson.addProperty("imageUrl", image.url);
      imageJson.addProperty("imageLink", image.link);
      bodyJson.add("image", imageJson);
    }

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/friend-talk", bodyJson.toString()));
      return new SendFriendtalk(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }


  public SendFriendtalk sendFriendtalkWithVariables(
      String profileId, String templateId, List<ToWithVariable> to,
      String message, List<Button> buttons, boolean isAd,
      Reservation reservation, Fallback fallback, Image image
  ) {
    JsonObject bodyJson = new JsonObject();
    bodyJson.addProperty("sendProfileId", profileId);
    bodyJson.addProperty("templateId", templateId);
    bodyJson.addProperty("mesageType", MessageType.FT.value);
    bodyJson.add("to", gson.toJsonTree(to));
    bodyJson.addProperty("message", message);
    bodyJson.addProperty("isAd", isAd);

    if (buttons != null) {
      JsonArray buttonsArray = new JsonArray();
      for (Button button : buttons) {
        JsonObject buttonObject = new JsonObject();
        buttonObject.addProperty("name", button.name);
        buttonObject.addProperty("ordering", button.ordering);
        buttonObject.addProperty("type", button.type.value);

        if (button instanceof WlButton) {
          WlButton wlButton = (WlButton) button;
          buttonObject.addProperty("urlMobile", wlButton.urlMobile);
          buttonObject.addProperty("urlPc", wlButton.urlPc);
        } else if (button instanceof AlButton) {
          AlButton alButton = (AlButton) button;
          buttonObject.addProperty("schemeIos", alButton.schemeIos);
          buttonObject.addProperty("schemeAndroid", alButton.schemeAndroid);
        }
        buttonsArray.add(buttonObject);
      }
      bodyJson.add("buttons", buttonsArray);
    }

    if (reservation != null) {
      JsonObject reservationJson = new JsonObject();
      reservationJson.addProperty("datetime", reservation.datetime);
      bodyJson.add("reservation", reservationJson);
    }

    if (fallback != null) {
      JsonObject fallbackJson = new JsonObject();
      fallbackJson.addProperty("fallbackType", fallback.fallbackType.value);
      JsonObject fallbackCustom = new JsonObject();
      fallbackCustom.addProperty("type", fallback.custom.type.value);
      fallbackCustom.addProperty("senderNumber", fallback.custom.senderNumber);
      fallbackCustom.addProperty("isAd", fallback.custom.isAd);
      fallbackCustom.addProperty("message", fallback.custom.message);
      fallbackCustom.addProperty("title", fallback.custom.title);
      fallbackCustom.add("images", gson.toJsonTree(fallback.custom.images));
      fallbackJson.add("custom", fallbackCustom);
      bodyJson.add("fallback", fallbackJson);
    }

    if (image != null) {
      JsonObject imageJson
          = new JsonObject();
      imageJson.addProperty("imageUrl", image.url);
      imageJson.addProperty("imageLink", image.link);
      bodyJson.add("image", imageJson);
    }

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(post("/v2/messages/kakao/friend-talk", bodyJson.toString()));
      return new SendFriendtalk(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }
}
